/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public final class JadeFabricUtils {
    private JadeFabricUtils() {
    }

    public static List<ViewGroup<class_2487>> fromFluidStorage(Storage<FluidVariant> storage) {
        ArrayList list = Lists.newArrayList();
        long emptyCapacity = 0L;
        for (StorageView view : storage) {
            long capacity = view.getCapacity();
            if (capacity <= 0L) continue;
            if (view.isResourceBlank() || view.getAmount() <= 0L) {
                emptyCapacity = LongMath.saturatedAdd((long)emptyCapacity, (long)capacity);
                continue;
            }
            list.add(FluidView.writeDefault(JadeFluidObject.of(((FluidVariant)view.getResource()).getFluid(), view.getAmount(), ((FluidVariant)view.getResource()).getComponents()), capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0L) {
            list.add(FluidView.writeDefault(JadeFluidObject.empty(), emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }

    public static ItemIterator<? extends Storage<ItemVariant>> fromItemStorage(Storage<ItemVariant> storage, int fromIndex) {
        return JadeFabricUtils.fromItemStorage(storage, fromIndex, CommonProxy::findItemHandler);
    }

    public static ItemIterator<? extends Storage<ItemVariant>> fromItemStorage(Storage<ItemVariant> storage, int fromIndex, Function<Accessor<?>, @Nullable Storage<ItemVariant>> containerFinder) {
        if (storage instanceof SlottedStorage) {
            return new ItemIterator.SlottedItemIterator<SlottedStorage<ItemVariant>>(accessor -> {
                Object patt0$temp = containerFinder.apply((Accessor<?>)accessor);
                if (patt0$temp instanceof SlottedStorage) {
                    SlottedStorage slotted = (SlottedStorage)patt0$temp;
                    return slotted;
                }
                return null;
            }, fromIndex){

                @Override
                protected int getSlotCount(SlottedStorage<ItemVariant> container) {
                    return container.getSlotCount();
                }

                @Override
                protected class_1799 getItemInSlot(SlottedStorage<ItemVariant> container, int slot) {
                    SingleSlotStorage slotStorage = container.getSlot(slot);
                    return ((ItemVariant)slotStorage.getResource()).toStack((int)class_3532.method_53062((long)slotStorage.getAmount(), (long)0L, (long)Integer.MAX_VALUE));
                }

                @Override
                public long getVersion(SlottedStorage<ItemVariant> container) {
                    return container.getVersion();
                }
            };
        }
        return new ItemIterator.SlotlessItemIterator<Storage<ItemVariant>>(containerFinder, fromIndex){

            @Override
            protected Stream<class_1799> populateRaw(Storage<ItemVariant> container) {
                return Streams.stream((Iterator)container.nonEmptyIterator()).map($ -> ((ItemVariant)$.getResource()).toStack((int)class_3532.method_53062((long)$.getAmount(), (long)0L, (long)Integer.MAX_VALUE)));
            }

            @Override
            public long getVersion(Storage<ItemVariant> container) {
                return container.getVersion();
            }
        };
    }
}

