/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.WrapperFactory;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final Minecraft MC = Minecraft.getInstance();
    private static final IWrapperFactory FACTORY = WrapperFactory.INSTANCE;
    private static final IOptifineAccessor OPTIFINE_ACCESSOR = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
    public ConcurrentHashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new ConcurrentHashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean colorTextureCastFailLogged = false;
    public boolean depthTextureCastFailLogged = false;

    @Override
    public Vec3f getLookAtVector() {
        Camera camera = MinecraftRenderWrapper.MC.gameRenderer.getMainCamera();
        return new Vec3f(camera.getLookVector().x(), camera.getLookVector().y(), camera.getLookVector().z());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        return MinecraftRenderWrapper.MC.player.getActiveEffectsMap().get(MobEffects.BLINDNESS) != null || MinecraftRenderWrapper.MC.player.getActiveEffectsMap().get(MobEffects.DARKNESS) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        Camera camera = MinecraftRenderWrapper.MC.gameRenderer.getMainCamera();
        Vec3 projectedView = camera.getPosition();
        return new Vec3d(projectedView.x, projectedView.y, projectedView.z);
    }

    @Override
    public Color getFogColor(float partialTicks) {
        FogRenderer.setupColor((Camera)MinecraftRenderWrapper.MC.gameRenderer.getMainCamera(), (float)partialTicks, (ClientLevel)MinecraftRenderWrapper.MC.level, (int)1, (float)MinecraftRenderWrapper.MC.gameRenderer.getDarkenWorldAmount(partialTicks));
        float[] colorValues = RenderSystem.getShaderFogColor();
        return new Color(Math.max(0.0f, Math.min(colorValues[0], 1.0f)), Math.max(0.0f, Math.min(colorValues[1], 1.0f)), Math.max(0.0f, Math.min(colorValues[2], 1.0f)), Math.max(0.0f, Math.min(colorValues[3], 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.level.dimensionType().hasSkyLight()) {
            float frameTime = MC.getTimer().getRealtimeDeltaTicks();
            Vec3 colorValues = MinecraftRenderWrapper.MC.level.getSkyColor(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getPosition(), frameTime);
            return new Color((float)colorValues.x, (float)colorValues.y, (float)colorValues.z);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.gameRenderer.getFov(MinecraftRenderWrapper.MC.gameRenderer.getMainCamera(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.options.getEffectiveRenderDistance();
    }

    @Override
    public int getScreenWidth() {
        int width = MC.getWindow().getWidth();
        if (OPTIFINE_ACCESSOR != null) {
            width = (int)((double)width * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return width;
    }

    @Override
    public int getScreenHeight() {
        int height = MC.getWindow().getHeight();
        if (OPTIFINE_ACCESSOR != null) {
            height = (int)((double)height * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return height;
    }

    private RenderTarget getRenderTarget() {
        return MC.getMainRenderTarget();
    }

    @Override
    public boolean mcRendersToFrameBuffer() {
        return true;
    }

    @Override
    public boolean runningLegacyOpenGL() {
        return false;
    }

    @Override
    public int getTargetFrameBuffer() {
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return this.getRenderTarget().frameBufferId;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        return this.getRenderTarget().getDepthTextureId();
    }

    @Override
    public int getColorTextureId() {
        return this.getRenderTarget().getColorTextureId();
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().viewWidth;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().viewHeight;
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.gameRenderer.getMainCamera().getFluidInCamera() != FogType.NONE || isBlind;
    }

    public void updateLightmap(NativeImage lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.uploadLightmap(lightPixels);
    }

    public void setLightmapId(int tetxureId, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.setLightmapId(tetxureId);
    }
}

