/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.google.common.collect.ImmutableList;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.LodUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhGenerationChunkHolder;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DummyLightEngine;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.StaticCache2D;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DhLitWorldGenRegion
extends WorldGenRegion {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static ChunkStatus debugTriggeredForStatus = null;
    public final ServerLevel serverLevel;
    public final DummyLightEngine lightEngine;
    public final BatchGenerationEnvironment.IEmptyChunkRetrievalFunc generator;
    public final int writeRadius;
    public final int size;
    private final ChunkPos firstPos;
    private final List<ChunkAccess> cache;
    private final Long2ObjectOpenHashMap<ChunkAccess> chunkMap = new Long2ObjectOpenHashMap();
    private final ReentrantLock getChunkLock = new ReentrantLock();

    public DhLitWorldGenRegion(int centerChunkX, int centerChunkZ, ChunkAccess centerChunk, ServerLevel serverLevel, DummyLightEngine lightEngine, List<ChunkAccess> chunkList, ChunkStatus chunkStatus, int writeRadius, BatchGenerationEnvironment.IEmptyChunkRetrievalFunc generator) {
        super(serverLevel, StaticCache2D.create((int)centerChunkX, (int)centerChunkZ, (int)(writeRadius * 2), (x, z) -> new DhGenerationChunkHolder(new ChunkPos(x, z))), new ChunkStep(chunkStatus, new ChunkDependencies(ImmutableList.copyOf((Collection)ChunkStatus.getStatusList()).reverse()), new ChunkDependencies(ImmutableList.copyOf((Collection)ChunkStatus.getStatusList()).reverse()), writeRadius, (var1, var2, var3, var4) -> null), centerChunk);
        this.firstPos = chunkList.get(0).getPos();
        this.serverLevel = serverLevel;
        this.generator = generator;
        this.lightEngine = lightEngine;
        this.writeRadius = writeRadius;
        this.cache = chunkList;
        this.size = Mth.floor((double)Math.sqrt(chunkList.size()));
    }

    public boolean ensureCanWrite(BlockPos blockPos) {
        int i = SectionPos.blockToSectionCoord((int)blockPos.getX());
        int j = SectionPos.blockToSectionCoord((int)blockPos.getZ());
        ChunkPos chunkPos = this.getCenter();
        ChunkAccess center = this.getChunk(chunkPos.x, chunkPos.z);
        int k = Math.abs(chunkPos.x - i);
        int l = Math.abs(chunkPos.z - j);
        if (k > this.writeRadius || l > this.writeRadius) {
            return false;
        }
        if (center.isUpgrading()) {
            LevelHeightAccessor levelHeightAccessor = center.getHeightAccessorForGeneration();
            int minY = levelHeightAccessor.getMinBuildHeight();
            int maxY = levelHeightAccessor.getMaxBuildHeight();
            if (blockPos.getY() < minY || blockPos.getY() >= maxY) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    @NotNull
    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    public boolean setBlock(BlockPos blockPos, BlockState blockState, int i, int j) {
        ChunkAccess chunkAccess = this.getChunk(blockPos);
        if (chunkAccess instanceof LevelChunk) {
            return true;
        }
        chunkAccess.setBlockState(blockPos, blockState, false);
        return true;
    }

    public boolean destroyBlock(BlockPos blockPos, boolean bl, @Nullable Entity entity, int i) {
        BlockState blockState = this.getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        return this.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3, i);
    }

    public BlockEntity getBlockEntity(BlockPos blockPos) {
        BlockState blockState = this.getBlockState(blockPos);
        if (blockState.getBlock() instanceof SpawnerBlock) {
            return ((EntityBlock)blockState.getBlock()).newBlockEntity(blockPos, blockState);
        }
        return null;
    }

    @NotNull
    public BlockState getBlockState(BlockPos blockPos) {
        int chunkX = SectionPos.blockToSectionCoord((int)blockPos.getX());
        int chunkZ = SectionPos.blockToSectionCoord((int)blockPos.getZ());
        return this.getChunk(chunkX, chunkZ).getBlockState(blockPos);
    }

    public boolean addFreshEntity(@NotNull Entity entity) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ChunkAccess getChunk(int chunkX, int chunkZ) {
        try {
            this.getChunkLock.lock();
            ChunkAccess chunkAccess = this.getChunk(chunkX, chunkZ, ChunkStatus.EMPTY);
            return chunkAccess;
        }
        finally {
            this.getChunkLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ChunkAccess getChunk(int chunkX, int chunkZ, @NotNull ChunkStatus chunkStatus) {
        try {
            this.getChunkLock.lock();
            ChunkAccess chunk = this.getChunk(chunkX, chunkZ, chunkStatus, true);
            if (chunk == null) {
                LodUtil.assertNotReach("getChunk shouldn't return null values");
            }
            ChunkAccess chunkAccess = chunk;
            return chunkAccess;
        }
        finally {
            this.getChunkLock.unlock();
        }
    }

    @Nullable
    public ChunkAccess getChunk(int chunkX, int chunkZ, @NotNull ChunkStatus chunkStatus, boolean returnNonNull) {
        ChunkAccess chunk = this.getChunkAccess(chunkX, chunkZ, chunkStatus, returnNonNull);
        if (chunk instanceof LevelChunk) {
            chunk = new ImposterProtoChunk((LevelChunk)chunk, true);
        }
        return chunk;
    }

    private ChunkAccess getChunkAccess(int chunkX, int chunkZ, ChunkStatus chunkStatus, boolean returnNonNull) {
        ChunkAccess chunk;
        ChunkAccess chunkAccess = chunk = this.superHasChunk(chunkX, chunkZ) ? this.superGetChunk(chunkX, chunkZ) : null;
        if (chunk != null && ChunkWrapper.getStatus(chunk).isOrAfter(chunkStatus)) {
            return chunk;
        }
        if (!returnNonNull) {
            return null;
        }
        if (chunk == null && (chunk = (ChunkAccess)this.chunkMap.get(ChunkPos.asLong((int)chunkX, (int)chunkZ))) == null) {
            chunk = this.generator.getChunk(chunkX, chunkZ);
            if (chunk == null) {
                throw new NullPointerException("The provided generator should not return null!");
            }
            this.chunkMap.put(ChunkPos.asLong((int)chunkX, (int)chunkZ), (Object)chunk);
        }
        if (chunkStatus != ChunkStatus.EMPTY && chunkStatus != debugTriggeredForStatus) {
            LOGGER.info("WorldGen requiring " + String.valueOf(chunkStatus) + " outside expected range detected. Force passing EMPTY chunk and seeing if it works.");
            debugTriggeredForStatus = chunkStatus;
        }
        return chunk;
    }

    public boolean superHasChunk(int x, int z) {
        int k = x - this.firstPos.x;
        int l = z - this.firstPos.z;
        return l >= 0 && l < this.size && k >= 0 && k < this.size;
    }

    private ChunkAccess superGetChunk(int x, int z) {
        int k = x - this.firstPos.x;
        int l = z - this.firstPos.z;
        return this.cache.get(k + l * this.size);
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    public int getBrightness(@NotNull LightLayer lightLayer, @NotNull BlockPos blockPos) {
        return 0;
    }

    public int getRawBrightness(@NotNull BlockPos blockPos, int i) {
        return 0;
    }

    public boolean canSeeSky(@NotNull BlockPos blockPos) {
        return this.getBrightness(LightLayer.SKY, blockPos) >= 15;
    }

    public int getBlockTint(@NotNull BlockPos blockPos, @NotNull ColorResolver colorResolver) {
        return this.calculateBlockTint(blockPos, colorResolver);
    }

    private Biome _getBiome(BlockPos pos) {
        return (Biome)this.getBiome(pos).value();
    }

    public int calculateBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        int i = (Integer)Minecraft.getInstance().options.biomeBlendRadius().get();
        if (i == 0) {
            return colorResolver.getColor(this._getBiome(blockPos), (double)blockPos.getX(), (double)blockPos.getZ());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        Cursor3D cursor3D = new Cursor3D(blockPos.getX() - i, blockPos.getY(), blockPos.getZ() - i, blockPos.getX() + i, blockPos.getY(), blockPos.getZ() + i);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.advance()) {
            mutableBlockPos.set(cursor3D.nextX(), cursor3D.nextY(), cursor3D.nextZ());
            int n = colorResolver.getColor(this._getBiome((BlockPos)mutableBlockPos), (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }
}

