/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9283;
import net.minecraft.class_9284;
import net.minecraft.class_9334;

public class EmiFireworkRocketRecipe
extends EmiPatternCraftingRecipe {
    private static final List<class_1769> DYES = Stream.of(class_1767.values()).map(class_1769::method_7803).toList();

    public EmiFireworkRocketRecipe(class_2960 id) {
        super(List.of(EmiStack.of((class_1935)class_1802.field_8407), EmiStack.of((class_1935)class_1802.field_8450), EmiStack.of((class_1935)class_1802.field_8054)), EmiStack.of((class_1935)class_1802.field_8639), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new SlotWidget(EmiStack.of((class_1935)class_1802.field_8407), x, y);
        }
        int s = slot - 1;
        return new GeneratedSlotWidget(r -> {
            List<EmiStack> items = this.getItems((Random)r);
            if (s < items.size()) {
                return items.get(s);
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(this::getFireworkRocket, this.unique, x, y);
    }

    private EmiStack getFireworkRocket(Random random) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8639);
        ArrayList<class_9283> explosions = new ArrayList<class_9283>();
        List<EmiStack> items = this.getItems(random);
        int gunpowder = 0;
        for (EmiStack item : items) {
            if (item.getId() == EmiStack.of((class_1935)class_1802.field_8450).getId()) {
                explosions.add(item.getOrDefault(class_9334.field_49615, class_9283.field_49315));
                continue;
            }
            if (!item.isEqual(EmiStack.of((class_1935)class_1802.field_8054))) continue;
            ++gunpowder;
        }
        stack.method_57379(class_9334.field_49616, (Object)new class_9284(gunpowder, explosions));
        return EmiStack.of(stack, 3L);
    }

    private List<EmiStack> getItems(Random random) {
        int i;
        ArrayList items = Lists.newArrayList();
        int amount = random.nextInt(3);
        for (i = 0; i <= amount; ++i) {
            items.add(EmiStack.of((class_1935)class_1802.field_8054));
        }
        amount = random.nextInt(8 - items.size());
        for (i = 0; i <= amount; ++i) {
            items.add(this.getFireworkStar(random));
        }
        return items;
    }

    private List<class_1769> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random) {
        IntList fadedColors;
        class_1799 stack = new class_1799((class_1935)class_1802.field_8450);
        int items = 0;
        int amount = random.nextInt(5);
        class_9283.class_1782 type = class_9283.class_1782.values()[random.nextInt(class_9283.class_1782.values().length)];
        if (amount != 0) {
            ++items;
        }
        amount = random.nextInt(4);
        boolean flicker = false;
        boolean trail = false;
        if (amount == 0) {
            flicker = true;
            ++items;
        } else if (amount == 1) {
            trail = true;
            ++items;
        } else if (amount == 2) {
            flicker = true;
            trail = true;
            items += 2;
        }
        List<class_1769> dyeItems = this.getDyes(random, 8 - items);
        IntArrayList colors = new IntArrayList();
        for (class_1769 dyeItem : dyeItems) {
            colors.add(dyeItem.method_7802().method_7790());
        }
        amount = random.nextInt(2);
        if (amount == 1) {
            List<class_1769> dyeItemsFaded = this.getDyes(random, 8);
            fadedColors = new IntArrayList();
            for (class_1769 dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.method_7802().method_7790());
            }
        } else {
            fadedColors = IntLists.emptyList();
        }
        class_9283 component = new class_9283(type, (IntList)colors, fadedColors, trail, flicker);
        stack.method_57379(class_9334.field_49615, (Object)component);
        return EmiStack.of(stack);
    }
}

