/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.screen.widget;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.EmiPort;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import dev.emi.emi.search.EmiSearch;
import dev.emi.emi.search.QueryType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_7833;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

public class EmiSearchWidget
extends class_342 {
    private static final Pattern ESCAPE = Pattern.compile("\\\\.");
    private List<String> searchHistory = Lists.newArrayList();
    private int searchHistoryIndex = 0;
    private List<class_3545<Integer, class_2583>> styles;
    private long lastClick = 0L;
    private String last = "";
    private long lastRender = System.currentTimeMillis();
    private long accumulatedSpin = 0L;
    public boolean highlight = false;
    public boolean isFocused;

    public EmiSearchWidget(class_327 textRenderer, int x, int y, int width, int height) {
        super(textRenderer, x, y, width, height, (class_2561)EmiPort.literal(""));
        this.method_1856(true);
        this.method_1868(-1);
        this.method_1860(-1);
        this.method_1880(256);
        this.method_1854((string, stringStart) -> {
            int end;
            class_3545<Integer, class_2583> style;
            int s;
            class_5250 text = null;
            int last = 0;
            for (s = 0; s < this.styles.size(); ++s) {
                style = this.styles.get(s);
                end = (Integer)style.method_15442();
                if (end <= stringStart) continue;
                if (end - stringStart >= string.length()) {
                    text = EmiPort.literal(string.substring(0, string.length()), (class_2583)style.method_15441());
                    s = this.styles.size();
                    break;
                }
                text = EmiPort.literal(string.substring(0, end - stringStart), (class_2583)style.method_15441());
                last = end - stringStart;
                ++s;
                break;
            }
            while (s < this.styles.size()) {
                style = this.styles.get(s);
                end = (Integer)style.method_15442();
                if (end - stringStart >= string.length()) {
                    EmiPort.append(text, (class_2561)EmiPort.literal(string.substring(last, string.length()), (class_2583)style.method_15441()));
                    break;
                }
                EmiPort.append(text, (class_2561)EmiPort.literal(string.substring(last, end - stringStart), (class_2583)style.method_15441()));
                last = end - stringStart;
                ++s;
            }
            return EmiPort.ordered(text);
        });
        this.method_1863(string -> {
            if (string.isEmpty()) {
                this.method_1887(class_1074.method_4662((String)"emi.search", (Object[])new Object[0]));
            } else {
                this.method_1887("");
            }
            EmiScreenManager.updateSearchSidebar();
            Matcher matcher = EmiSearch.TOKENS.matcher((CharSequence)string);
            ArrayList styles = Lists.newArrayList();
            int last = 0;
            while (matcher.find()) {
                String group;
                int start = matcher.start();
                int end = matcher.end();
                if (last < start) {
                    styles.add(new class_3545((Object)start, (Object)class_2583.field_24360.method_27706(class_124.field_1068)));
                }
                if ((group = matcher.group()).startsWith("-")) {
                    styles.add(new class_3545((Object)(start + 1), (Object)class_2583.field_24360.method_27706(class_124.field_1061)));
                    ++start;
                    group = group.substring(1);
                }
                QueryType type = QueryType.fromString(group);
                int subStart = type.prefix.length();
                if (group.length() > 1 + subStart && group.substring(subStart).startsWith("/") && group.endsWith("/")) {
                    int rOff = start + subStart + 1;
                    styles.add(new class_3545((Object)rOff, (Object)type.slashColor));
                    Matcher rMatcher = ESCAPE.matcher(string.substring(rOff, end - 1));
                    int rLast = 0;
                    while (rMatcher.find()) {
                        int rStart = rMatcher.start();
                        int rEnd = rMatcher.end();
                        if (rLast < rStart) {
                            styles.add(new class_3545((Object)(rStart + rOff), (Object)type.regexColor));
                        }
                        styles.add(new class_3545((Object)(rEnd + rOff), (Object)type.escapeColor));
                        rLast = rEnd;
                    }
                    if (rLast < end - 1) {
                        styles.add(new class_3545((Object)(end - 1), (Object)type.regexColor));
                    }
                    styles.add(new class_3545((Object)end, (Object)type.slashColor));
                } else {
                    styles.add(new class_3545((Object)end, (Object)type.color));
                }
                last = end;
            }
            if (last < string.length()) {
                styles.add(new class_3545((Object)string.length(), (Object)class_2583.field_24360.method_27706(class_124.field_1068)));
            }
            this.styles = styles;
            EmiSearch.search(string);
        });
    }

    public void update() {
        this.method_1852(this.method_1882());
    }

    public void swap() {
        String last = this.method_1882();
        this.method_1852(this.last);
        this.last = last;
    }

    public void method_25365(boolean focused) {
        if (!focused) {
            this.searchHistoryIndex = 0;
            String currentSearch = this.method_1882();
            if (!currentSearch.isBlank() && !currentSearch.isEmpty()) {
                this.searchHistory.removeIf(String::isBlank);
                this.searchHistory.remove(currentSearch);
                this.searchHistory.add(0, currentSearch);
                if (this.searchHistory.size() > 36) {
                    this.searchHistory.remove(this.searchHistory.size() - 1);
                }
            }
        }
        this.isFocused = focused;
        super.method_25365(focused);
        EmiScreenManager.updateSearchSidebar();
    }

    public boolean method_25370() {
        return this.isFocused;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.method_25405(mouseX, mouseY) || !EmiConfig.enabled) {
            EmiPort.focus(this, false);
            return false;
        }
        boolean b = super.method_25402(mouseX, mouseY, button == 1 ? 0 : button);
        if (this.method_25405(mouseX, mouseY)) {
            EmiPort.focus(this, true);
        }
        if (this.method_25370()) {
            if (button == 0) {
                if (System.currentTimeMillis() - this.lastClick < 500L) {
                    this.highlight = !this.highlight;
                    this.lastClick = 0L;
                } else {
                    this.lastClick = System.currentTimeMillis();
                }
            } else if (button == 1) {
                this.method_1852("");
                EmiPort.focus(this, true);
            }
        }
        return b;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_25370()) {
            if (EmiConfig.clearSearch.matchesKey(keyCode, scanCode)) {
                this.method_1852("");
                return true;
            }
            if (EmiConfig.focusSearch.matchesKey(keyCode, scanCode) || keyCode == 257 || keyCode == 256) {
                EmiPort.focus(this, false);
                return true;
            }
            if (keyCode == 265 || keyCode == 264) {
                int offset;
                int n = offset = keyCode == 265 ? 1 : -1;
                if (this.searchHistoryIndex + offset >= 0 && this.searchHistoryIndex + offset < this.searchHistory.size()) {
                    if (this.searchHistoryIndex >= 0 && this.searchHistoryIndex < this.searchHistory.size()) {
                        this.searchHistory.set(this.searchHistoryIndex, this.method_1882());
                    }
                    this.searchHistoryIndex += offset;
                    this.method_1852(this.searchHistory.get(this.searchHistoryIndex));
                }
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_48579(class_332 raw, int mouseX, int mouseY, float delta) {
        EmiDrawContext context = EmiDrawContext.wrap(raw);
        this.method_1888(EmiConfig.enabled);
        String lower = this.method_1882().toLowerCase();
        boolean dinnerbone = lower.contains("dinnerbone");
        this.accumulatedSpin += (long)(dinnerbone ? 1 : -1) * Math.abs(System.currentTimeMillis() - this.lastRender);
        if (this.accumulatedSpin < 0L) {
            this.accumulatedSpin = 0L;
        } else if (this.accumulatedSpin > 500L) {
            this.accumulatedSpin = 500L;
        }
        this.lastRender = System.currentTimeMillis();
        long deg = this.accumulatedSpin * -180L / 500L;
        Matrix4fStack view = RenderSystem.getModelViewStack();
        view.pushMatrix();
        if (deg != 0L) {
            view.translate((float)(this.field_22760 + this.field_22758 / 2), (float)(this.field_22761 + this.field_22759 / 2), 0.0f);
            view.rotate((Quaternionfc)class_7833.field_40717.rotationDegrees((float)deg));
            view.translate((float)(-(this.field_22760 + this.field_22758 / 2)), (float)(-(this.field_22761 + this.field_22759 / 2)), 0.0f);
            EmiPort.applyModelViewMatrix();
        }
        if (lower.contains("jeb_")) {
            int amount = 1023;
            float h = (float)(this.lastRender & (long)amount) % (float)amount / (float)amount;
            int rgb = class_3532.method_15369((float)h, (float)1.0f, (float)1.0f);
            context.setColor((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb >> 0 & 0xFF) / 255.0f);
        }
        if (EmiConfig.enabled) {
            super.method_48579(context.raw(), mouseX, mouseY, delta);
            if (this.highlight) {
                int border = -1118720;
                context.fill(this.field_22760 - 1, this.field_22761 - 1, this.field_22758 + 2, 1, border);
                context.fill(this.field_22760 - 1, this.field_22761 + this.field_22759, this.field_22758 + 2, 1, border);
                context.fill(this.field_22760 - 1, this.field_22761 - 1, 1, this.field_22759 + 2, border);
                context.fill(this.field_22760 + this.field_22758, this.field_22761 - 1, 1, this.field_22759 + 2, border);
            }
        }
        context.resetColor();
        view.popMatrix();
        EmiPort.applyModelViewMatrix();
    }
}

