/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.tooltip;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.ShulkerBoxTooltipApi;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PositionAwareClientTooltipComponent;
import com.misterpemodder.shulkerboxtooltip.impl.tooltip.PreviewTooltipComponent;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class PreviewClientTooltipComponent
extends PositionAwareClientTooltipComponent {
    private final PreviewRenderer renderer;
    private final PreviewProvider provider;
    private final PreviewContext context;

    public PreviewClientTooltipComponent(PreviewTooltipComponent data) {
        PreviewRenderer renderer = data.provider().getRenderer();
        if (renderer == null) {
            renderer = PreviewRenderer.getDefaultRendererInstance();
        }
        this.renderer = renderer;
        this.provider = data.provider();
        this.context = data.context();
        renderer.setPreview(this.context, this.provider);
        renderer.setPreviewType(ShulkerBoxTooltipApi.getCurrentPreviewType(this.provider.isFullPreviewAvailable(this.context)));
    }

    public int method_32661() {
        if (ShulkerBoxTooltip.config.preview.position == Configuration.PreviewPosition.INSIDE) {
            return this.renderer.getHeight() + 2 + 4;
        }
        return 0;
    }

    public int method_32664(class_327 font) {
        if (ShulkerBoxTooltip.config.preview.position == Configuration.PreviewPosition.INSIDE) {
            return this.renderer.getWidth() + 2;
        }
        return 0;
    }

    public void method_32666(class_327 font, int x, int y, class_332 graphics) {
        this.drawAt(x, y, graphics, font, 0, 0);
    }

    @Override
    public void drawItemsWithTooltipPosition(class_327 font, int x, int y, class_332 graphics, int tooltipTopY, int tooltipBottomY, int mouseX, int mouseY) {
        Configuration.PreviewPosition position = ShulkerBoxTooltip.config.preview.position;
        if (position != Configuration.PreviewPosition.INSIDE) {
            int h = this.renderer.getHeight();
            int w = this.renderer.getWidth();
            int screenW = graphics.method_51421();
            int screenH = graphics.method_51443();
            x = Math.min(x - 4, screenW - w);
            y = tooltipBottomY;
            if (position == Configuration.PreviewPosition.OUTSIDE_TOP || position == Configuration.PreviewPosition.OUTSIDE && y + h > screenH) {
                y = tooltipTopY - h;
            }
        }
        this.drawAt(x, y, graphics, font, mouseX, mouseY);
    }

    private void drawAt(int x, int y, class_332 graphics, class_327 font, int mouseX, int mouseY) {
        this.renderer.draw(x, y, graphics, font, mouseX, mouseY);
    }
}

