/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.DebugRenderState;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.FullMapData;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.MapChunkCache;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.MutableBlockPosCache;
import com.mamiyaotaru.voxelmap.util.MutableNativeImageBackedTexture;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.ScaledMutableNativeImageBackedTexture;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1043;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2506;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_308;
import net.minecraft.class_315;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_418;
import net.minecraft.class_4184;
import net.minecraft.class_428;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_5539;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_7924;
import net.minecraft.class_8251;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;
import org.lwjgl.BufferUtils;

public class Map
implements Runnable,
IChangeObserver {
    private final float[] lastLightBrightnessTable = new float[16];
    private final Object coordinateLock = new Object();
    private final class_2960 arrowResourceLocation = class_2960.method_60655((String)"voxelmap", (String)"images/mmarrow.png");
    private final class_2960 roundmapResourceLocation = class_2960.method_60655((String)"voxelmap", (String)"images/roundmap.png");
    private final class_2960 squareStencil = class_2960.method_60655((String)"voxelmap", (String)"images/square.png");
    private final class_2960 circleStencil = class_2960.method_60655((String)"voxelmap", (String)"images/circle.png");
    private class_638 world;
    private final MapSettingsManager options;
    private final LayoutVariables layoutVariables;
    private final ColorManager colorManager;
    private final WaypointManager waypointManager;
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    private final boolean multicore = this.availableProcessors > 1;
    private final int heightMapResetHeight = this.multicore ? 2 : 5;
    private final int heightMapResetTime = this.multicore ? 300 : 3000;
    private final boolean threading = this.multicore;
    private final FullMapData[] mapData = new FullMapData[5];
    private final MapChunkCache[] chunkCache = new MapChunkCache[5];
    private MutableNativeImageBackedTexture[] mapImages;
    private final MutableNativeImageBackedTexture[] mapImagesFiltered = new MutableNativeImageBackedTexture[5];
    private final MutableNativeImageBackedTexture[] mapImagesUnfiltered = new MutableNativeImageBackedTexture[5];
    private class_2680 transparentBlockState;
    private class_2680 surfaceBlockState;
    private boolean imageChanged = true;
    private class_1043 lightmapTexture;
    private boolean needLightmapRefresh = true;
    private int tickWithLightChange;
    private boolean lastPaused = true;
    private double lastGamma;
    private float lastSunBrightness;
    private float lastLightning;
    private float lastPotion;
    private final int[] lastLightmapValues = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private boolean lastBeneathRendering;
    private boolean needSkyColor;
    private boolean lastAboveHorizon = true;
    private int lastBiome;
    private int lastSkyColor;
    private final Random generator = new Random();
    private boolean showWelcomeScreen;
    private class_437 lastGuiScreen;
    private boolean fullscreenMap;
    private int zoom;
    private int scWidth;
    private int scHeight;
    private String error = "";
    private final class_2561[] welcomeText = new class_2561[8];
    private int ztimer;
    private int heightMapFudge;
    private int timer;
    private boolean doFullRender = true;
    private boolean zoomChanged;
    private int lastX;
    private int lastZ;
    private int lastY;
    private int lastImageX;
    private int lastImageZ;
    private boolean lastFullscreen;
    private float direction;
    private float percentX;
    private float percentY;
    private int northRotate;
    private Thread zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
    private int zCalcTicker;
    private final class_327 fontRenderer;
    private final int[] lightmapColors = new int[256];
    private double zoomScale = 1.0;
    private double zoomScaleAdjusted = 1.0;
    private int mapImageInt = -1;
    private static double minTablistOffset;
    private static float statusIconOffset;

    public Map() {
        this.options = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.colorManager = VoxelConstants.getVoxelMapInstance().getColorManager();
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.layoutVariables = new LayoutVariables();
        ArrayList<class_304> tempBindings = new ArrayList<class_304>();
        tempBindings.addAll(Arrays.asList(VoxelConstants.getMinecraft().field_1690.field_1839));
        tempBindings.addAll(Arrays.asList(this.options.keyBindings));
        Field f = ReflectionUtils.getFieldByType(VoxelConstants.getMinecraft().field_1690, class_315.class, class_304[].class, 1);
        try {
            f.set(VoxelConstants.getMinecraft().field_1690, tempBindings.toArray(new class_304[0]));
        }
        catch (IllegalAccessException | IllegalArgumentException var7) {
            VoxelConstants.getLogger().error((Object)var7);
        }
        java.util.Map categoryOrder = (java.util.Map)ReflectionUtils.getPrivateFieldValueByType(null, class_304.class, java.util.Map.class, 2);
        VoxelConstants.getLogger().warn("CATEGORY ORDER IS " + categoryOrder.size());
        Integer categoryPlace = (Integer)categoryOrder.get("controls.minimap.title");
        if (categoryPlace == null) {
            int currentSize = categoryOrder.size();
            categoryOrder.put("controls.minimap.title", currentSize + 1);
        }
        this.showWelcomeScreen = this.options.welcome;
        this.zCalc.start();
        this.mapData[0] = new FullMapData(32, 32);
        this.mapData[1] = new FullMapData(64, 64);
        this.mapData[2] = new FullMapData(128, 128);
        this.mapData[3] = new FullMapData(256, 256);
        this.mapData[4] = new FullMapData(512, 512);
        this.chunkCache[0] = new MapChunkCache(3, 3, this);
        this.chunkCache[1] = new MapChunkCache(5, 5, this);
        this.chunkCache[2] = new MapChunkCache(9, 9, this);
        this.chunkCache[3] = new MapChunkCache(17, 17, this);
        this.chunkCache[4] = new MapChunkCache(33, 33, this);
        this.mapImagesFiltered[0] = new MutableNativeImageBackedTexture(32, 32, true);
        this.mapImagesFiltered[1] = new MutableNativeImageBackedTexture(64, 64, true);
        this.mapImagesFiltered[2] = new MutableNativeImageBackedTexture(128, 128, true);
        this.mapImagesFiltered[3] = new MutableNativeImageBackedTexture(256, 256, true);
        this.mapImagesFiltered[4] = new MutableNativeImageBackedTexture(512, 512, true);
        this.mapImagesUnfiltered[0] = new ScaledMutableNativeImageBackedTexture(32, 32, true);
        this.mapImagesUnfiltered[1] = new ScaledMutableNativeImageBackedTexture(64, 64, true);
        this.mapImagesUnfiltered[2] = new ScaledMutableNativeImageBackedTexture(128, 128, true);
        this.mapImagesUnfiltered[3] = new ScaledMutableNativeImageBackedTexture(256, 256, true);
        this.mapImagesUnfiltered[4] = new ScaledMutableNativeImageBackedTexture(512, 512, true);
        this.mapImages = this.options.filtering ? this.mapImagesFiltered : this.mapImagesUnfiltered;
        OpenGL.Utils.setupFramebuffer();
        this.fontRenderer = VoxelConstants.getMinecraft().field_1772;
        this.zoom = this.options.zoom;
        this.setZoomScale();
    }

    public void forceFullRender(boolean forceFullRender) {
        this.doFullRender = forceFullRender;
        VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    public float getPercentX() {
        return this.percentX;
    }

    public float getPercentY() {
        return this.percentY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (VoxelConstants.getMinecraft() != null) {
            while (true) {
                if (this.world != null) {
                    if (!this.options.hide && this.options.minimapAllowed) {
                        try {
                            this.mapCalc(this.doFullRender);
                            if (!this.doFullRender) {
                                MutableBlockPos blockPos = MutableBlockPosCache.get();
                                this.chunkCache[this.zoom].centerChunks(blockPos.withXYZ(this.lastX, 0, this.lastZ));
                                MutableBlockPosCache.release(blockPos);
                                this.chunkCache[this.zoom].checkIfChunksChanged();
                            }
                        }
                        catch (Exception exception) {
                            VoxelConstants.getLogger().error("Voxelmap LiveMap Calculation Thread", (Throwable)exception);
                        }
                    }
                    this.doFullRender = this.zoomChanged;
                    this.zoomChanged = false;
                }
                this.zCalcTicker = 0;
                Thread thread = this.zCalc;
                synchronized (thread) {
                    try {
                        this.zCalc.wait(0L);
                    }
                    catch (InterruptedException exception) {
                        VoxelConstants.getLogger().error("Voxelmap LiveMap Calculation Thread", (Throwable)exception);
                    }
                }
            }
        }
    }

    public void newWorld(class_638 world) {
        this.world = world;
        this.lightmapTexture = this.getLightmapTexture();
        this.mapData[this.zoom].blank();
        this.doFullRender = true;
        VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    public void newWorldName() {
        String subworldName = this.waypointManager.getCurrentSubworldDescriptor(true);
        StringBuilder subworldNameBuilder = new StringBuilder("\u00a7r").append(class_1074.method_4662((String)"worldmap.multiworld.newworld", (Object[])new Object[0])).append(":").append(" ");
        if (subworldName.isEmpty() && this.waypointManager.isMultiworld()) {
            subworldNameBuilder.append("???");
        } else if (!subworldName.isEmpty()) {
            subworldNameBuilder.append(subworldName);
        }
        this.error = subworldNameBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame(class_332 drawContext) {
        int n = this.northRotate = this.options.oldNorth ? 90 : 0;
        if (this.lightmapTexture == null) {
            this.lightmapTexture = this.getLightmapTexture();
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindMenu.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            VoxelConstants.getMinecraft().method_1507((class_437)new GuiPersistentMap(null));
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindWaypointMenu.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            if (VoxelMap.mapOptions.waypointsAllowed) {
                VoxelConstants.getMinecraft().method_1507((class_437)new GuiWaypoints(null));
            }
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindWaypoint.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            }
            if (VoxelMap.mapOptions.waypointsAllowed) {
                float b;
                float g;
                float r;
                if (this.waypointManager.getWaypoints().isEmpty()) {
                    r = 0.0f;
                    g = 1.0f;
                    b = 0.0f;
                } else {
                    r = this.generator.nextFloat();
                    g = this.generator.nextFloat();
                    b = this.generator.nextFloat();
                }
                TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_37908()));
                double dimensionScale = VoxelConstants.getPlayer().method_37908().method_8597().comp_646();
                Waypoint newWaypoint = new Waypoint("", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord(), true, r, g, b, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
                VoxelConstants.getMinecraft().method_1507((class_437)new GuiAddWaypoint(null, newWaypoint, false));
            }
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindMobToggle.method_1436()) {
            VoxelConstants.getVoxelMapInstance().getRadarOptions().setOptionValue(EnumOptionsMinimap.SHOWRADAR);
            this.options.saveAll();
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindWaypointToggle.method_1436()) {
            this.options.toggleIngameWaypoints();
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindZoom.method_1436()) {
            this.showWelcomeScreen = false;
            if (this.options.welcome) {
                this.options.welcome = false;
                this.options.saveAll();
            } else {
                this.cycleZoomLevel();
            }
        }
        if (VoxelConstants.getMinecraft().field_1755 == null && this.options.keyBindFullscreen.method_1436()) {
            boolean bl = this.fullscreenMap = !this.fullscreenMap;
            this.error = this.zoom == 4 ? class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (0.25x)" : (this.zoom == 3 ? class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (0.5x)" : (this.zoom == 2 ? class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (1.0x)" : (this.zoom == 1 ? class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (2.0x)" : class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (4.0x)")));
        }
        this.checkForChanges();
        if (VoxelMap.mapOptions.deathWaypointAllowed && VoxelConstants.getMinecraft().field_1755 instanceof class_418 && !(this.lastGuiScreen instanceof class_418)) {
            this.waypointManager.handleDeath();
        }
        this.lastGuiScreen = VoxelConstants.getMinecraft().field_1755;
        this.calculateCurrentLightAndSkyColor();
        if (this.threading) {
            if (!this.zCalc.isAlive()) {
                this.zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
                this.zCalc.start();
                this.zCalcTicker = 0;
            }
            if (!(VoxelConstants.getMinecraft().field_1755 instanceof class_418) && !(VoxelConstants.getMinecraft().field_1755 instanceof class_428)) {
                ++this.zCalcTicker;
                if (this.zCalcTicker > 2000) {
                    this.zCalcTicker = 0;
                    Exception ex = new Exception();
                    ex.setStackTrace(this.zCalc.getStackTrace());
                    DebugRenderState.print();
                    VoxelConstants.getLogger().error("Voxelmap LiveMap Calculation Thread is hanging?", (Throwable)ex);
                }
                Thread ex = this.zCalc;
                synchronized (ex) {
                    this.zCalc.notify();
                }
            }
        } else {
            if (!this.options.hide && this.options.minimapAllowed && this.world != null) {
                this.mapCalc(this.doFullRender);
                if (!this.doFullRender) {
                    MutableBlockPos blockPos = MutableBlockPosCache.get();
                    this.chunkCache[this.zoom].centerChunks(blockPos.withXYZ(this.lastX, 0, this.lastZ));
                    MutableBlockPosCache.release(blockPos);
                    this.chunkCache[this.zoom].checkIfChunksChanged();
                }
            }
            this.doFullRender = false;
        }
        boolean enabled = !VoxelConstants.getMinecraft().field_1690.field_1842 && (this.options.showUnderMenus || VoxelConstants.getMinecraft().field_1755 == null) && !VoxelConstants.getMinecraft().method_53526().method_53536();
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (!this.error.isEmpty() && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.ztimer == 0 && !this.error.isEmpty()) {
            this.error = "";
        }
        if (enabled && VoxelMap.mapOptions.minimapAllowed) {
            this.drawMinimap(drawContext);
        }
        this.timer = this.timer > 5000 ? 0 : this.timer + 1;
    }

    private void cycleZoomLevel() {
        if (this.options.zoom == 4) {
            this.options.zoom = 3;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (0.5x)";
        } else if (this.options.zoom == 3) {
            this.options.zoom = 2;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (1.0x)";
        } else if (this.options.zoom == 2) {
            this.options.zoom = 1;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (2.0x)";
        } else if (this.options.zoom == 1) {
            this.options.zoom = 0;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (4.0x)";
        } else if (this.options.zoom == 0) {
            if (this.multicore && (Integer)VoxelConstants.getMinecraft().field_1690.method_42503().method_41753() > 8) {
                this.options.zoom = 4;
                this.error = class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (0.25x)";
            } else {
                this.options.zoom = 3;
                this.error = class_1074.method_4662((String)"minimap.ui.zoomlevel", (Object[])new Object[0]) + " (0.5x)";
            }
        }
        this.options.saveAll();
        this.zoomChanged = true;
        this.zoom = this.options.zoom;
        this.setZoomScale();
        this.doFullRender = true;
    }

    private void setZoomScale() {
        this.zoomScale = Math.pow(2.0, this.zoom) / 2.0;
        this.zoomScaleAdjusted = this.options.squareMap && this.options.rotates ? this.zoomScale / (double)1.4142f : this.zoomScale;
    }

    private class_1043 getLightmapTexture() {
        class_765 lightTextureManager = VoxelConstants.getMinecraft().field_1773.method_22974();
        Object lightmapTextureObj = ReflectionUtils.getPrivateFieldValueByType(lightTextureManager, class_765.class, class_1043.class);
        return lightmapTextureObj == null ? null : (class_1043)lightmapTextureObj;
    }

    public void calculateCurrentLightAndSkyColor() {
        try {
            if (this.world != null) {
                boolean aboveHorizon;
                boolean scheduledUpdate;
                int lastLightningBolt;
                int t;
                if (this.needLightmapRefresh && VoxelConstants.getElapsedTicks() != this.tickWithLightChange && !VoxelConstants.getMinecraft().method_1493() || this.options.realTimeTorches) {
                    OpenGL.Utils.disp(this.lightmapTexture.method_4624());
                    ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
                    OpenGL.glGetTexImage(3553, 0, 6408, 5121, byteBuffer);
                    for (int i = 0; i < this.lightmapColors.length; ++i) {
                        int index = i * 4;
                        this.lightmapColors[i] = (byteBuffer.get(index + 3) << 24) + (byteBuffer.get(index) << 16) + (byteBuffer.get(index + 1) << 8) + byteBuffer.get(index + 2);
                    }
                    if (this.lightmapColors[255] != 0) {
                        this.needLightmapRefresh = false;
                    }
                }
                boolean lightChanged = false;
                if ((Double)VoxelConstants.getMinecraft().field_1690.method_42473().method_41753() != this.lastGamma) {
                    lightChanged = true;
                    this.lastGamma = (Double)VoxelConstants.getMinecraft().field_1690.method_42473().method_41753();
                }
                float[] providerLightBrightnessTable = new float[16];
                for (t = 0; t < 16; ++t) {
                    providerLightBrightnessTable[t] = this.world.method_8597().method_28528((long)t);
                }
                for (t = 0; t < 16; ++t) {
                    if (providerLightBrightnessTable[t] == this.lastLightBrightnessTable[t]) continue;
                    lightChanged = true;
                    this.lastLightBrightnessTable[t] = providerLightBrightnessTable[t];
                }
                float sunBrightness = this.world.method_23783(1.0f);
                if ((double)Math.abs(this.lastSunBrightness - sunBrightness) > 0.01 || (double)sunBrightness == 1.0 && sunBrightness != this.lastSunBrightness || (double)sunBrightness == 0.0 && sunBrightness != this.lastSunBrightness) {
                    lightChanged = true;
                    this.needSkyColor = true;
                    this.lastSunBrightness = sunBrightness;
                }
                float potionEffect = 0.0f;
                if (VoxelConstants.getPlayer().method_6059(class_1294.field_5925)) {
                    int duration = VoxelConstants.getPlayer().method_6112(class_1294.field_5925).method_5584();
                    float f = potionEffect = duration > 200 ? 1.0f : 0.7f + class_3532.method_15374((float)(((float)duration - 1.0f) * (float)Math.PI * 0.2f)) * 0.3f;
                }
                if (this.lastPotion != potionEffect) {
                    this.lastPotion = potionEffect;
                    lightChanged = true;
                }
                if (this.lastLightning != (float)(lastLightningBolt = this.world.method_23789())) {
                    this.lastLightning = lastLightningBolt;
                    lightChanged = true;
                }
                if (this.lastPaused != VoxelConstants.getMinecraft().method_1493()) {
                    this.lastPaused = !this.lastPaused;
                    lightChanged = true;
                }
                boolean bl = scheduledUpdate = (this.timer - 50) % (this.lastLightBrightnessTable[0] == 0.0f ? 250 : 2000) == 0;
                if (lightChanged || scheduledUpdate) {
                    this.tickWithLightChange = VoxelConstants.getElapsedTicks();
                    this.needLightmapRefresh = true;
                }
                boolean bl2 = aboveHorizon = VoxelConstants.getPlayer().method_5836((float)0.0f).field_1351 >= this.world.method_28104().method_28105((class_5539)this.world);
                if (this.world.method_27983().method_29177().toString().toLowerCase().contains("ether")) {
                    aboveHorizon = true;
                }
                if (aboveHorizon != this.lastAboveHorizon) {
                    this.needSkyColor = true;
                    this.lastAboveHorizon = aboveHorizon;
                }
                MutableBlockPos blockPos = MutableBlockPosCache.get();
                int biomeID = this.world.method_30349().method_30530(class_7924.field_41236).method_10206((Object)((class_1959)this.world.method_23753((class_2338)blockPos.withXYZ(GameVariableAccessShim.xCoord(), GameVariableAccessShim.yCoord(), GameVariableAccessShim.zCoord())).comp_349()));
                MutableBlockPosCache.release(blockPos);
                if (biomeID != this.lastBiome) {
                    this.needSkyColor = true;
                    this.lastBiome = biomeID;
                }
                if (this.needSkyColor || scheduledUpdate) {
                    this.colorManager.setSkyColor(this.getSkyColor());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private int getSkyColor() {
        this.needSkyColor = false;
        boolean aboveHorizon = this.lastAboveHorizon;
        float[] fogColors = new float[4];
        FloatBuffer temp = BufferUtils.createFloatBuffer((int)4);
        class_758.method_3210((class_4184)VoxelConstants.getMinecraft().field_1773.method_19418(), (float)0.0f, (class_638)this.world, (int)((Integer)VoxelConstants.getMinecraft().field_1690.method_42503().method_41753()), (float)VoxelConstants.getMinecraft().field_1773.method_3195(0.0f));
        OpenGL.glGetFloatv(3106, temp);
        temp.get(fogColors);
        float r = fogColors[0];
        float g = fogColors[1];
        float b = fogColors[2];
        if (!aboveHorizon && (Integer)VoxelConstants.getMinecraft().field_1690.method_42503().method_41753() >= 4) {
            return 0xA000000 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        }
        int backgroundColor = -16777216 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        float[] sunsetColors = this.world.method_28103().method_28109(this.world.method_30274(0.0f), 0.0f);
        if (sunsetColors != null && (Integer)VoxelConstants.getMinecraft().field_1690.method_42503().method_41753() >= 4) {
            int sunsetColor = (int)(sunsetColors[3] * 128.0f) * 0x1000000 + (int)(sunsetColors[0] * 255.0f) * 65536 + (int)(sunsetColors[1] * 255.0f) * 256 + (int)(sunsetColors[2] * 255.0f);
            return ColorUtils.colorAdder(sunsetColor, backgroundColor);
        }
        return backgroundColor;
    }

    public int[] getLightmapArray() {
        return this.lightmapColors;
    }

    public void drawMinimap(class_332 drawContext) {
        int scScaleOrig = 1;
        while (VoxelConstants.getMinecraft().method_22683().method_4489() / (scScaleOrig + 1) >= 320 && VoxelConstants.getMinecraft().method_22683().method_4506() / (scScaleOrig + 1) >= 240) {
            ++scScaleOrig;
        }
        int scScale = scScaleOrig + (this.fullscreenMap ? 0 : this.options.sizeModifier);
        double scaledWidthD = (double)VoxelConstants.getMinecraft().method_22683().method_4489() / (double)scScale;
        double scaledHeightD = (double)VoxelConstants.getMinecraft().method_22683().method_4506() / (double)scScale;
        this.scWidth = class_3532.method_15384((double)scaledWidthD);
        this.scHeight = class_3532.method_15384((double)scaledHeightD);
        RenderSystem.backupProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().ortho(0.0f, (float)scaledWidthD, (float)scaledHeightD, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43360);
        Matrix4fStack modelViewMatrixStack = RenderSystem.getModelViewStack();
        modelViewMatrixStack.pushMatrix();
        modelViewMatrixStack.identity();
        modelViewMatrixStack.translate(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        int mapX = this.options.mapCorner != 0 && this.options.mapCorner != 3 ? this.scWidth - 37 : 37;
        int mapY = this.options.mapCorner != 0 && this.options.mapCorner != 1 ? this.scHeight - 37 : 37;
        float statusIconOffset = 0.0f;
        if (VoxelMap.mapOptions.moveMapDownWhileStatusEffect && this.options.mapCorner == 1 && !VoxelConstants.getPlayer().method_6026().isEmpty()) {
            for (class_1293 statusEffectInstance : VoxelConstants.getPlayer().method_6026()) {
                if (!statusEffectInstance.method_5592()) continue;
                if (((class_1291)statusEffectInstance.method_5579().comp_349()).method_5573()) {
                    statusIconOffset = Math.max(statusIconOffset, 24.0f);
                    continue;
                }
                statusIconOffset = 50.0f;
            }
            int scHeight = VoxelConstants.getMinecraft().method_22683().method_4502();
            float resFactor = (float)this.scHeight / (float)scHeight;
            mapY += (int)(statusIconOffset * resFactor);
        }
        Map.statusIconOffset = statusIconOffset;
        OpenGL.glEnable(3042);
        OpenGL.glBlendFunc(770, 0);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (!this.options.hide) {
            if (this.fullscreenMap) {
                this.renderMapFull(drawContext, this.scWidth, this.scHeight);
            } else {
                this.renderMap(modelViewMatrixStack, mapX, mapY, scScale);
            }
            OpenGL.glDisable(2929);
            if (VoxelConstants.getVoxelMapInstance().getRadar() != null && !this.fullscreenMap) {
                this.layoutVariables.updateVars(scScale, mapX, mapY, this.zoomScale, this.zoomScaleAdjusted);
                VoxelConstants.getVoxelMapInstance().getRadar().onTickInGame(drawContext, modelViewMatrixStack, this.layoutVariables);
            }
            if (!this.fullscreenMap) {
                this.drawDirections(drawContext, mapX, mapY);
            }
            OpenGL.glEnable(3042);
            if (this.fullscreenMap) {
                this.drawArrow(modelViewMatrixStack, this.scWidth / 2, this.scHeight / 2);
            } else {
                this.drawArrow(modelViewMatrixStack, mapX, mapY);
            }
        }
        if (this.options.coords) {
            this.showCoords(drawContext, mapX, mapY);
        }
        OpenGL.glDepthMask(true);
        OpenGL.glEnable(2929);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        modelViewMatrixStack.popMatrix();
        RenderSystem.restoreProjectionMatrix();
        RenderSystem.applyModelViewMatrix();
        OpenGL.glDisable(2929);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        VoxelConstants.getMinecraft().field_1772.getClass();
        class_4597.class_4598 vertexConsumerProvider = VoxelConstants.getMinecraft().method_22940().method_23000();
        VoxelConstants.getMinecraft().field_1772.method_30882((class_2561)class_2561.method_43470((String)"******sdkfjhsdkjfhsdkjfh"), 100.0f, 100.0f, -1, true, matrix4f, (class_4597)vertexConsumerProvider, class_327.class_6415.field_33993, 0, 0xF000F0);
        if (this.showWelcomeScreen) {
            OpenGL.glEnable(3042);
            this.drawWelcomeScreen(drawContext, VoxelConstants.getMinecraft().method_22683().method_4486(), VoxelConstants.getMinecraft().method_22683().method_4502());
        }
        OpenGL.glDepthMask(true);
        OpenGL.glEnable(2929);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        OpenGL.glTexParameteri(3553, 10241, 9728);
        OpenGL.glTexParameteri(3553, 10240, 9728);
        OpenGL.glDisable(3042);
    }

    private void checkForChanges() {
        boolean changed = false;
        if (this.colorManager.checkForChanges()) {
            this.loadMapImage();
            changed = true;
        }
        if (this.options.isChanged()) {
            this.mapImages = this.options.filtering ? this.mapImagesFiltered : this.mapImagesUnfiltered;
            changed = true;
            this.setZoomScale();
        }
        if (changed) {
            this.doFullRender = true;
            VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapCalc(boolean full) {
        int color24;
        int imageX;
        int imageY;
        boolean beneathRendering;
        int currentX = GameVariableAccessShim.xCoord();
        int currentZ = GameVariableAccessShim.zCoord();
        int currentY = GameVariableAccessShim.yCoord();
        int offsetX = currentX - this.lastX;
        int offsetZ = currentZ - this.lastZ;
        int offsetY = currentY - this.lastY;
        int zoom = this.zoom;
        int multi = (int)Math.pow(2.0, zoom);
        class_638 world = this.world;
        boolean needHeightMap = false;
        boolean needLight = false;
        boolean skyColorChanged = false;
        int skyColor = this.colorManager.getAirColor();
        if (this.lastSkyColor != skyColor) {
            skyColorChanged = true;
            this.lastSkyColor = skyColor;
        }
        if (this.options.lightmap) {
            int torchOffset = this.options.realTimeTorches ? 8 : 0;
            int skylightMultiplier = 16;
            for (int t = 0; t < 16; ++t) {
                if (this.lastLightmapValues[t] == this.lightmapColors[t * skylightMultiplier + torchOffset]) continue;
                needLight = true;
                this.lastLightmapValues[t] = this.lightmapColors[t * skylightMultiplier + torchOffset];
            }
        }
        if (offsetY != 0) {
            ++this.heightMapFudge;
        } else if (this.heightMapFudge != 0) {
            ++this.heightMapFudge;
        }
        if (full || Math.abs(offsetY) >= this.heightMapResetHeight || this.heightMapFudge > this.heightMapResetTime) {
            if (this.lastY != currentY) {
                needHeightMap = true;
            }
            this.lastY = currentY;
            this.heightMapFudge = 0;
        }
        if (Math.abs(offsetX) > 32 * multi || Math.abs(offsetZ) > 32 * multi) {
            full = true;
        }
        boolean nether = false;
        boolean caves = false;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), world.method_31600() - 1), world.method_31607()), this.lastZ);
        if (VoxelConstants.getPlayer().method_37908().method_8597().comp_643()) {
            boolean netherPlayerInOpen = world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (VoxelConstants.getClientWorld().method_28103().method_28114() && !VoxelConstants.getClientWorld().method_8597().comp_642()) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && world.method_8314(class_1944.field_9284, (class_2338)blockPos) <= 0) {
            caves = true;
        }
        MutableBlockPosCache.release(blockPos);
        boolean bl = beneathRendering = caves || nether;
        if (this.lastBeneathRendering != beneathRendering) {
            full = true;
        }
        this.lastBeneathRendering = beneathRendering;
        boolean needHeightAndID = needHeightMap && (nether || caves);
        Object object = this.coordinateLock;
        synchronized (object) {
            if (!full) {
                this.mapImages[zoom].moveY(offsetZ);
                this.mapImages[zoom].moveX(offsetX);
            }
            this.lastX = currentX;
            this.lastZ = currentZ;
        }
        int startX = currentX - 16 * multi;
        int startZ = currentZ - 16 * multi;
        if (!full) {
            this.mapData[zoom].moveZ(offsetZ);
            this.mapData[zoom].moveX(offsetX);
            for (imageY = offsetZ > 0 ? 32 * multi - 1 : -offsetZ - 1; imageY >= (offsetZ > 0 ? 32 * multi - offsetZ : 0); --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                    this.mapImages[zoom].setRGB(imageX, imageY, color24);
                }
            }
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = offsetX > 0 ? 32 * multi - offsetX : 0; imageX < (offsetX > 0 ? 32 * multi : -offsetX); ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                    this.mapImages[zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if (full || this.options.heightmap && needHeightMap || needHeightAndID || this.options.lightmap && needLight || skyColorChanged) {
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(full, full || needHeightAndID, full, full || needLight || needHeightAndID, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                    this.mapImages[zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if ((full || offsetX != 0 || offsetZ != 0 || !this.lastFullscreen) && this.fullscreenMap && this.options.biomeOverlay != 0) {
            this.mapData[zoom].segmentBiomes();
            this.mapData[zoom].findCenterOfSegments(!this.options.oldNorth);
        }
        this.lastFullscreen = this.fullscreenMap;
        if (full || offsetX != 0 || offsetZ != 0 || needHeightMap || needLight || skyColorChanged) {
            this.imageChanged = true;
        }
        if (needLight || skyColorChanged) {
            VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    @Override
    public void handleChangeInWorld(int chunkX, int chunkZ) {
        try {
            this.chunkCache[this.zoom].registerChangeAt(chunkX, chunkZ);
        }
        catch (Exception e) {
            VoxelConstants.getLogger().warn((Object)e);
        }
    }

    @Override
    public void processChunk(class_2818 chunk) {
        this.rectangleCalc(chunk.method_12004().field_9181 * 16, chunk.method_12004().field_9180 * 16, chunk.method_12004().field_9181 * 16 + 15, chunk.method_12004().field_9180 * 16 + 15);
    }

    private void rectangleCalc(int left, int top, int right, int bottom) {
        boolean nether = false;
        boolean caves = false;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), this.world.method_31600()), this.world.method_31607()), this.lastZ);
        int currentY = GameVariableAccessShim.yCoord();
        if (VoxelConstants.getPlayer().method_37908().method_8597().comp_643()) {
            boolean netherPlayerInOpen = this.world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (VoxelConstants.getClientWorld().method_28103().method_28114() && !VoxelConstants.getClientWorld().method_8597().comp_642()) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = this.world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.method_8314(class_1944.field_9284, (class_2338)blockPos) <= 0) {
            caves = true;
        }
        MutableBlockPosCache.release(blockPos);
        int zoom = this.zoom;
        int startX = this.lastX;
        int startZ = this.lastZ;
        class_638 world = this.world;
        int multi = (int)Math.pow(2.0, zoom);
        left = left - (startX -= 16 * multi) - 1;
        right = right - startX + 1;
        top = top - (startZ -= 16 * multi) - 1;
        bottom = bottom - startZ + 1;
        left = Math.max(0, left);
        right = Math.min(32 * multi - 1, right);
        top = Math.max(0, top);
        for (int imageY = bottom = Math.min(32 * multi - 1, bottom); imageY >= top; --imageY) {
            for (int imageX = left; imageX <= right; ++imageX) {
                int color24 = this.getPixelColor(true, true, true, true, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                this.mapImages[zoom].setRGB(imageX, imageY, color24);
            }
        }
        this.imageChanged = true;
    }

    private int getPixelColor(boolean needBiome, boolean needHeightAndID, boolean needTint, boolean needLight, boolean nether, boolean caves, class_638 world, int zoom, int multi, int startX, int startZ, int imageX, int imageY) {
        int color24;
        class_1959 biome;
        int surfaceHeight = Short.MIN_VALUE;
        int seafloorHeight = Short.MIN_VALUE;
        int transparentHeight = Short.MIN_VALUE;
        int foliageHeight = Short.MIN_VALUE;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        this.surfaceBlockState = null;
        this.transparentBlockState = BlockRepository.air.method_9564();
        class_2680 foliageBlockState = BlockRepository.air.method_9564();
        class_2680 seafloorBlockState = BlockRepository.air.method_9564();
        boolean surfaceBlockChangeForcedTint = false;
        boolean transparentBlockChangeForcedTint = false;
        boolean foliageBlockChangeForcedTint = false;
        boolean seafloorBlockChangeForcedTint = false;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        MutableBlockPos tempBlockPos = MutableBlockPosCache.get();
        blockPos.withXYZ(startX + imageX, 64, startZ + imageY);
        if (needBiome) {
            biome = world.method_22340((class_2338)blockPos) ? (class_1959)world.method_23753((class_2338)blockPos).comp_349() : null;
            this.mapData[zoom].setBiome(imageX, imageY, biome);
        } else {
            biome = this.mapData[zoom].getBiome(imageX, imageY);
        }
        if (this.options.biomeOverlay == 1) {
            color24 = biome != null ? BiomeRepository.getBiomeColor(biome) | 0xFF000000 : 0;
        } else {
            int light;
            int surfaceColor;
            int seafloorBlockStateID;
            int transparentBlockStateID;
            int foliageBlockStateID;
            int surfaceBlockStateID;
            boolean solid = false;
            if (needHeightAndID) {
                if (!nether && !caves) {
                    class_265 voxelShape;
                    boolean hasOpacity;
                    class_2818 chunk = world.method_8500((class_2338)blockPos);
                    transparentHeight = chunk.method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) + 1;
                    this.transparentBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY));
                    class_3610 fluidState = this.transparentBlockState.method_26227();
                    if (fluidState != class_3612.field_15906.method_15785()) {
                        this.transparentBlockState = fluidState.method_15759();
                    }
                    surfaceHeight = transparentHeight;
                    this.surfaceBlockState = this.transparentBlockState;
                    boolean bl = hasOpacity = this.surfaceBlockState.method_26193((class_1922)world, (class_2338)blockPos) > 0;
                    if (!hasOpacity && this.surfaceBlockState.method_26225() && this.surfaceBlockState.method_26211()) {
                        voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)blockPos, class_2350.field_11033);
                        hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                        voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)blockPos, class_2350.field_11036);
                        boolean bl2 = hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                    }
                    while (!hasOpacity && surfaceHeight > world.method_31607()) {
                        foliageBlockState = this.surfaceBlockState;
                        this.surfaceBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, --surfaceHeight - 1, startZ + imageY));
                        fluidState = this.surfaceBlockState.method_26227();
                        if (fluidState != class_3612.field_15906.method_15785()) {
                            this.surfaceBlockState = fluidState.method_15759();
                        }
                        if ((hasOpacity = this.surfaceBlockState.method_26193((class_1922)world, (class_2338)blockPos) > 0) || !this.surfaceBlockState.method_26225() || !this.surfaceBlockState.method_26211()) continue;
                        voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)blockPos, class_2350.field_11033);
                        hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                        voxelShape = this.surfaceBlockState.method_26173((class_1922)world, (class_2338)blockPos, class_2350.field_11036);
                        hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                    }
                    if (surfaceHeight == transparentHeight) {
                        transparentHeight = Short.MIN_VALUE;
                        this.transparentBlockState = BlockRepository.air.method_9564();
                        foliageBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
                    }
                    if (foliageBlockState.method_26204() == class_2246.field_10477) {
                        this.surfaceBlockState = foliageBlockState;
                        foliageBlockState = BlockRepository.air.method_9564();
                    }
                    if (foliageBlockState == this.transparentBlockState) {
                        foliageBlockState = BlockRepository.air.method_9564();
                    }
                    foliageHeight = foliageBlockState != null && !(foliageBlockState.method_26204() instanceof class_2189) ? surfaceHeight + 1 : Short.MIN_VALUE;
                    class_2248 material = this.surfaceBlockState.method_26204();
                    if (material == class_2246.field_10382 || material == class_2246.field_10295) {
                        seafloorHeight = surfaceHeight;
                        seafloorBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                        while (seafloorBlockState.method_26193((class_1922)world, (class_2338)blockPos) < 5 && !(seafloorBlockState.method_26204() instanceof class_2397) && seafloorHeight > world.method_31607() + 1) {
                            material = seafloorBlockState.method_26204();
                            if (transparentHeight == Short.MIN_VALUE && material != class_2246.field_10295 && material != class_2246.field_10382 && seafloorBlockState.method_51366()) {
                                transparentHeight = seafloorHeight;
                                this.transparentBlockState = seafloorBlockState;
                            }
                            if (foliageHeight == Short.MIN_VALUE && seafloorHeight != transparentHeight && this.transparentBlockState != seafloorBlockState && material != class_2246.field_10295 && material != class_2246.field_10382 && !(material instanceof class_2189) && material != class_2246.field_10422) {
                                foliageHeight = seafloorHeight;
                                foliageBlockState = seafloorBlockState;
                            }
                            seafloorBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, --seafloorHeight - 1, startZ + imageY));
                        }
                        if (seafloorBlockState.method_26204() == class_2246.field_10382) {
                            seafloorBlockState = BlockRepository.air.method_9564();
                        }
                    }
                } else {
                    surfaceHeight = this.getNetherHeight(startX + imageX, startZ + imageY);
                    this.surfaceBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                    surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
                    foliageHeight = surfaceHeight + 1;
                    blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                    foliageBlockState = world.method_8320((class_2338)blockPos);
                    class_2248 material = foliageBlockState.method_26204();
                    if (material != class_2246.field_10477 && !(material instanceof class_2189) && material != class_2246.field_10164 && material != class_2246.field_10382) {
                        foliageBlockStateID = BlockRepository.getStateId(foliageBlockState);
                    } else {
                        foliageHeight = Short.MIN_VALUE;
                    }
                }
                surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
                if (this.options.biomes && this.surfaceBlockState != this.mapData[zoom].getBlockstate(imageX, imageY)) {
                    surfaceBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setHeight(imageX, imageY, surfaceHeight);
                this.mapData[zoom].setBlockstateID(imageX, imageY, surfaceBlockStateID);
                if (this.options.biomes && this.transparentBlockState != this.mapData[zoom].getTransparentBlockstate(imageX, imageY)) {
                    transparentBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setTransparentHeight(imageX, imageY, transparentHeight);
                transparentBlockStateID = BlockRepository.getStateId(this.transparentBlockState);
                this.mapData[zoom].setTransparentBlockstateID(imageX, imageY, transparentBlockStateID);
                if (this.options.biomes && foliageBlockState != this.mapData[zoom].getFoliageBlockstate(imageX, imageY)) {
                    foliageBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setFoliageHeight(imageX, imageY, foliageHeight);
                foliageBlockStateID = BlockRepository.getStateId(foliageBlockState);
                this.mapData[zoom].setFoliageBlockstateID(imageX, imageY, foliageBlockStateID);
                if (this.options.biomes && seafloorBlockState != this.mapData[zoom].getOceanFloorBlockstate(imageX, imageY)) {
                    seafloorBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
                seafloorBlockStateID = BlockRepository.getStateId(seafloorBlockState);
                this.mapData[zoom].setOceanFloorBlockstateID(imageX, imageY, seafloorBlockStateID);
            } else {
                surfaceHeight = this.mapData[zoom].getHeight(imageX, imageY);
                surfaceBlockStateID = this.mapData[zoom].getBlockstateID(imageX, imageY);
                this.surfaceBlockState = BlockRepository.getStateById(surfaceBlockStateID);
                transparentHeight = this.mapData[zoom].getTransparentHeight(imageX, imageY);
                transparentBlockStateID = this.mapData[zoom].getTransparentBlockstateID(imageX, imageY);
                this.transparentBlockState = BlockRepository.getStateById(transparentBlockStateID);
                foliageHeight = this.mapData[zoom].getFoliageHeight(imageX, imageY);
                foliageBlockStateID = this.mapData[zoom].getFoliageBlockstateID(imageX, imageY);
                foliageBlockState = BlockRepository.getStateById(foliageBlockStateID);
                seafloorHeight = this.mapData[zoom].getOceanFloorHeight(imageX, imageY);
                seafloorBlockStateID = this.mapData[zoom].getOceanFloorBlockstateID(imageX, imageY);
                seafloorBlockState = BlockRepository.getStateById(seafloorBlockStateID);
            }
            if (surfaceHeight == Short.MIN_VALUE) {
                surfaceHeight = this.lastY + 1;
                solid = true;
            }
            if (this.surfaceBlockState.method_26204() == class_2246.field_10164) {
                solid = false;
            }
            if (this.options.biomes) {
                int tint;
                surfaceColor = this.colorManager.getBlockColor(blockPos, surfaceBlockStateID, biome);
                if (!needTint && !surfaceBlockChangeForcedTint) {
                    tint = this.mapData[zoom].getBiomeTint(imageX, imageY);
                } else {
                    tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, this.surfaceBlockState, surfaceBlockStateID, blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                    this.mapData[zoom].setBiomeTint(imageX, imageY, tint);
                }
                if (tint != -1) {
                    surfaceColor = ColorUtils.colorMultiplier(surfaceColor, tint);
                }
            } else {
                surfaceColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, surfaceBlockStateID);
            }
            surfaceColor = this.applyHeight(surfaceColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, surfaceHeight, solid, 1);
            if (needLight) {
                light = this.getLight(surfaceColor, this.surfaceBlockState, (class_1937)world, startX + imageX, startZ + imageY, surfaceHeight, solid);
                this.mapData[zoom].setLight(imageX, imageY, light);
            } else {
                light = this.mapData[zoom].getLight(imageX, imageY);
            }
            if (light == 0) {
                surfaceColor = 0;
            } else if (light != 255) {
                surfaceColor = ColorUtils.colorMultiplier(surfaceColor, light);
            }
            if (this.options.waterTransparency && seafloorHeight != Short.MIN_VALUE) {
                int seafloorLight;
                if (!this.options.biomes) {
                    seafloorColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, seafloorBlockStateID);
                } else {
                    int tint;
                    seafloorColor = this.colorManager.getBlockColor(blockPos, seafloorBlockStateID, biome);
                    if (!needTint && !seafloorBlockChangeForcedTint) {
                        tint = this.mapData[zoom].getOceanFloorBiomeTint(imageX, imageY);
                    } else {
                        tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, seafloorBlockState, seafloorBlockStateID, blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                        this.mapData[zoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                    }
                    if (tint != -1) {
                        seafloorColor = ColorUtils.colorMultiplier(seafloorColor, tint);
                    }
                }
                seafloorColor = this.applyHeight(seafloorColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
                if (needLight) {
                    seafloorLight = this.getLight(seafloorColor, seafloorBlockState, (class_1937)world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                    blockPos.setXYZ(startX + imageX, seafloorHeight, startZ + imageY);
                    class_2680 blockStateAbove = world.method_8320((class_2338)blockPos);
                    class_2248 materialAbove = blockStateAbove.method_26204();
                    if (this.options.lightmap && materialAbove == class_2246.field_10295) {
                        int multiplier = (Boolean)VoxelConstants.getMinecraft().field_1690.method_41792().method_41753() != false ? 200 : 120;
                        seafloorLight = ColorUtils.colorMultiplier(seafloorLight, 0xFF000000 | multiplier << 16 | multiplier << 8 | multiplier);
                    }
                    this.mapData[zoom].setOceanFloorLight(imageX, imageY, seafloorLight);
                } else {
                    seafloorLight = this.mapData[zoom].getOceanFloorLight(imageX, imageY);
                }
                if (seafloorLight == 0) {
                    seafloorColor = 0;
                } else if (seafloorLight != 255) {
                    seafloorColor = ColorUtils.colorMultiplier(seafloorColor, seafloorLight);
                }
            }
            if (this.options.blockTransparency) {
                if (transparentHeight != Short.MIN_VALUE && this.transparentBlockState != null && this.transparentBlockState != BlockRepository.air.method_9564()) {
                    int transparentLight;
                    if (this.options.biomes) {
                        int tint;
                        transparentColor = this.colorManager.getBlockColor(blockPos, transparentBlockStateID, biome);
                        if (!needTint && !transparentBlockChangeForcedTint) {
                            tint = this.mapData[zoom].getTransparentBiomeTint(imageX, imageY);
                        } else {
                            tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, this.transparentBlockState, transparentBlockStateID, blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                            this.mapData[zoom].setTransparentBiomeTint(imageX, imageY, tint);
                        }
                        if (tint != -1) {
                            transparentColor = ColorUtils.colorMultiplier(transparentColor, tint);
                        }
                    } else {
                        transparentColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, transparentBlockStateID);
                    }
                    transparentColor = this.applyHeight(transparentColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 3);
                    if (needLight) {
                        transparentLight = this.getLight(transparentColor, this.transparentBlockState, (class_1937)world, startX + imageX, startZ + imageY, transparentHeight, solid);
                        this.mapData[zoom].setTransparentLight(imageX, imageY, transparentLight);
                    } else {
                        transparentLight = this.mapData[zoom].getTransparentLight(imageX, imageY);
                    }
                    if (transparentLight == 0) {
                        transparentColor = 0;
                    } else if (transparentLight != 255) {
                        transparentColor = ColorUtils.colorMultiplier(transparentColor, transparentLight);
                    }
                }
                if (foliageHeight != Short.MIN_VALUE && foliageBlockState != null && foliageBlockState != BlockRepository.air.method_9564()) {
                    int foliageLight;
                    if (!this.options.biomes) {
                        foliageColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, foliageBlockStateID);
                    } else {
                        int tint;
                        foliageColor = this.colorManager.getBlockColor(blockPos, foliageBlockStateID, biome);
                        if (!needTint && !foliageBlockChangeForcedTint) {
                            tint = this.mapData[zoom].getFoliageBiomeTint(imageX, imageY);
                        } else {
                            tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, foliageBlockState, foliageBlockStateID, blockPos.withXYZ(startX + imageX, foliageHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                            this.mapData[zoom].setFoliageBiomeTint(imageX, imageY, tint);
                        }
                        if (tint != -1) {
                            foliageColor = ColorUtils.colorMultiplier(foliageColor, tint);
                        }
                    }
                    foliageColor = this.applyHeight(foliageColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, foliageHeight, solid, 2);
                    if (needLight) {
                        foliageLight = this.getLight(foliageColor, foliageBlockState, (class_1937)world, startX + imageX, startZ + imageY, foliageHeight, solid);
                        this.mapData[zoom].setFoliageLight(imageX, imageY, foliageLight);
                    } else {
                        foliageLight = this.mapData[zoom].getFoliageLight(imageX, imageY);
                    }
                    if (foliageLight == 0) {
                        foliageColor = 0;
                    } else if (foliageLight != 255) {
                        foliageColor = ColorUtils.colorMultiplier(foliageColor, foliageLight);
                    }
                }
            }
            if (seafloorColor != 0 && seafloorHeight > Short.MIN_VALUE) {
                color24 = seafloorColor;
                if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                    color24 = ColorUtils.colorAdder(foliageColor, seafloorColor);
                }
                if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                    color24 = ColorUtils.colorAdder(transparentColor, color24);
                }
                color24 = ColorUtils.colorAdder(surfaceColor, color24);
            } else {
                color24 = surfaceColor;
            }
            if (foliageColor != 0 && foliageHeight > surfaceHeight) {
                color24 = ColorUtils.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight > surfaceHeight) {
                color24 = ColorUtils.colorAdder(transparentColor, color24);
            }
            if (this.options.biomeOverlay == 2) {
                int bc = 0;
                if (biome != null) {
                    bc = BiomeRepository.getBiomeColor(biome);
                }
                bc = 0x7F000000 | bc;
                color24 = ColorUtils.colorAdder(bc, color24);
            }
        }
        MutableBlockPosCache.release(blockPos);
        MutableBlockPosCache.release(tempBlockPos);
        return MapUtils.doSlimeAndGrid(color24, world, startX + imageX, startZ + imageY);
    }

    private int getBlockHeight(boolean nether, boolean caves, class_1937 world, int x, int z) {
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        int playerHeight = GameVariableAccessShim.yCoord();
        blockPos.setXYZ(x, playerHeight, z);
        class_2818 chunk = (class_2818)world.method_22350((class_2338)blockPos);
        int height = chunk.method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) + 1;
        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(x, height - 1, z));
        class_3610 fluidState = this.transparentBlockState.method_26227();
        if (fluidState != class_3612.field_15906.method_15785()) {
            blockState = fluidState.method_15759();
        }
        while (blockState.method_26193((class_1922)world, (class_2338)blockPos) == 0 && height > world.method_31607()) {
            blockState = world.method_8320((class_2338)blockPos.withXYZ(x, --height - 1, z));
            fluidState = this.surfaceBlockState.method_26227();
            if (fluidState == class_3612.field_15906.method_15785()) continue;
            blockState = fluidState.method_15759();
        }
        MutableBlockPosCache.release(blockPos);
        return (nether || caves) && height > playerHeight ? this.getNetherHeight(x, z) : height;
    }

    private int getNetherHeight(int x, int z) {
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        int y = this.lastY;
        blockPos.setXYZ(x, y, z);
        class_2680 blockState = this.world.method_8320((class_2338)blockPos);
        if (blockState.method_26193((class_1922)this.world, (class_2338)blockPos) == 0 && blockState.method_26204() != class_2246.field_10164) {
            while (y > this.world.method_31607()) {
                blockPos.setXYZ(x, --y, z);
                blockState = this.world.method_8320((class_2338)blockPos);
                if (blockState.method_26193((class_1922)this.world, (class_2338)blockPos) <= 0 && blockState.method_26204() != class_2246.field_10164) continue;
                MutableBlockPosCache.release(blockPos);
                return y + 1;
            }
            MutableBlockPosCache.release(blockPos);
            return y;
        }
        while (y <= this.lastY + 10 && y < this.world.method_31600()) {
            blockPos.setXYZ(x, ++y, z);
            blockState = this.world.method_8320((class_2338)blockPos);
            if (blockState.method_26193((class_1922)this.world, (class_2338)blockPos) != 0 || blockState.method_26204() == class_2246.field_10164) continue;
            MutableBlockPosCache.release(blockPos);
            return y;
        }
        MutableBlockPosCache.release(blockPos);
        return -1;
    }

    private int getSeafloorHeight(class_1937 world, int x, int z, int height) {
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(x, height - 1, z));
        while (blockState.method_26193((class_1922)world, (class_2338)blockPos) < 5 && !(blockState.method_26204() instanceof class_2397) && height > world.method_31607() + 1) {
            blockState = world.method_8320((class_2338)blockPos.withXYZ(x, --height - 1, z));
        }
        MutableBlockPosCache.release(blockPos);
        return height;
    }

    private int getTransparentHeight(boolean nether, boolean caves, class_1937 world, int x, int z, int height) {
        int transHeight;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        if (!caves && !nether) {
            transHeight = world.method_8598(class_2902.class_2903.field_13197, (class_2338)blockPos.withXYZ(x, height, z)).method_10264();
            if (transHeight <= height) {
                transHeight = Short.MIN_VALUE;
            }
        } else {
            transHeight = Short.MIN_VALUE;
        }
        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(x, transHeight - 1, z));
        class_2248 material = blockState.method_26204();
        if (transHeight == height + 1 && material == class_2246.field_10477) {
            transHeight = Short.MIN_VALUE;
        }
        if (material == class_2246.field_10499 && (material = (blockState = world.method_8320((class_2338)blockPos.withXYZ(x, ++transHeight - 1, z))).method_26204()) instanceof class_2189) {
            transHeight = Short.MIN_VALUE;
        }
        MutableBlockPosCache.release(blockPos);
        return transHeight;
    }

    private int applyHeight(int color24, boolean nether, boolean caves, class_1937 world, int zoom, int multi, int startX, int startZ, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0 && (this.options.heightmap || this.options.slopemap) && !solid) {
            int heightComp = -1;
            double sc = 0.0;
            if (!this.options.slopemap) {
                int diff = height - this.lastY;
                sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                if (diff < 0) {
                    sc = 0.0 - sc;
                }
            } else {
                int diff;
                if (imageX > 0 && imageY < 32 * multi - 1) {
                    class_2248 block;
                    if (layer == 0) {
                        heightComp = this.mapData[zoom].getOceanFloorHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 1) {
                        heightComp = this.mapData[zoom].getHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.mapData[zoom].getTransparentHeight(imageX - 1, imageY + 1)) == Short.MIN_VALUE && ((block = BlockRepository.getStateById(this.mapData[zoom].getTransparentBlockstateID(imageX, imageY)).method_26204()) == class_2246.field_10033 || block instanceof class_2506)) {
                        heightComp = this.mapData[zoom].getHeight(imageX - 1, imageY + 1);
                    }
                } else {
                    int baseHeight;
                    if (layer == 0) {
                        baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                        heightComp = this.getSeafloorHeight(world, startX + imageX - 1, startZ + imageY + 1, baseHeight);
                    }
                    if (layer == 1) {
                        heightComp = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.getTransparentHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1, baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1))) == Short.MIN_VALUE) {
                        MutableBlockPos blockPos = MutableBlockPosCache.get();
                        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, height - 1, startZ + imageY));
                        MutableBlockPosCache.release(blockPos);
                        class_2248 block = blockState.method_26204();
                        if (block == class_2246.field_10033 || block instanceof class_2506) {
                            heightComp = baseHeight;
                        }
                    }
                }
                if (heightComp == Short.MIN_VALUE) {
                    heightComp = height;
                }
                if ((diff = heightComp - height) != 0) {
                    sc = diff > 0 ? 1.0 : -1.0;
                    sc /= 8.0;
                }
                if (this.options.heightmap) {
                    diff = height - this.lastY;
                    double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                    sc = diff > 0 ? sc + heightsc : sc - heightsc;
                }
            }
            int alpha = color24 >> 24 & 0xFF;
            int r = color24 >> 16 & 0xFF;
            int g = color24 >> 8 & 0xFF;
            int b = color24 & 0xFF;
            if (sc > 0.0) {
                r += (int)(sc * (double)(255 - r));
                g += (int)(sc * (double)(255 - g));
                b += (int)(sc * (double)(255 - b));
            } else if (sc < 0.0) {
                sc = Math.abs(sc);
                r -= (int)(sc * (double)r);
                g -= (int)(sc * (double)g);
                b -= (int)(sc * (double)b);
            }
            color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
        }
        return color24;
    }

    private int getLight(int color24, class_2680 blockState, class_1937 world, int x, int z, int height, boolean solid) {
        int combinedLight = 255;
        if (solid) {
            combinedLight = 0;
        } else if (color24 != this.colorManager.getAirColor() && color24 != 0 && this.options.lightmap) {
            MutableBlockPos blockPos = MutableBlockPosCache.get();
            blockPos.setXYZ(x, Math.max(Math.min(height, world.method_31600()), world.method_31607()), z);
            int blockLight = world.method_8314(class_1944.field_9282, (class_2338)blockPos);
            int skyLight = world.method_8314(class_1944.field_9284, (class_2338)blockPos);
            if (blockState.method_26204() == class_2246.field_10164 || blockState.method_26204() == class_2246.field_10092) {
                blockLight = 14;
            }
            MutableBlockPosCache.release(blockPos);
            combinedLight = this.lightmapColors[blockLight + skyLight * 16];
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(Matrix4fStack matrixStack, int x, int y, int scScale) {
        float scale = 1.0f;
        if (this.options.squareMap && this.options.rotates) {
            scale = 1.4142f;
        }
        OpenGL.glBindTexture(3553, 0);
        Matrix4f minimapProjectionMatrix = RenderSystem.getProjectionMatrix();
        RenderSystem.setShader(class_757::method_34542);
        Matrix4f matrix4f = new Matrix4f().ortho(0.0f, 512.0f, 512.0f, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43360);
        OpenGL.Utils.bindFramebuffer();
        OpenGL.glViewport(0, 0, 512, 512);
        matrixStack.pushMatrix();
        matrixStack.identity();
        matrixStack.translate(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        OpenGL.glDepthMask(false);
        OpenGL.glDisable(2929);
        OpenGL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        OpenGL.glClear(16384);
        OpenGL.glBlendFunc(770, 0);
        OpenGL.Utils.img2(this.options.squareMap ? this.squareStencil : this.circleStencil);
        OpenGL.Utils.drawPre();
        OpenGL.Utils.ldrawthree(256.0f - 256.0f / scale, 256.0f + 256.0f / scale, 1.0, 0.0f, 0.0f);
        OpenGL.Utils.ldrawthree(256.0f + 256.0f / scale, 256.0f + 256.0f / scale, 1.0, 1.0f, 0.0f);
        OpenGL.Utils.ldrawthree(256.0f + 256.0f / scale, 256.0f - 256.0f / scale, 1.0, 1.0f, 1.0f);
        OpenGL.Utils.ldrawthree(256.0f - 256.0f / scale, 256.0f - 256.0f / scale, 1.0, 0.0f, 1.0f);
        OpenGL.Utils.drawPost();
        OpenGL.glBlendFuncSeparate(1, 0, 774, 0);
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.mapImages[this.zoom].write();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        float multi = (float)(1.0 / this.zoomScale);
        this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
        this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
        this.percentX *= multi;
        this.percentY *= multi;
        OpenGL.Utils.disp2(this.mapImages[this.zoom].getIndex());
        OpenGL.glTexParameteri(3553, 10241, 9987);
        OpenGL.glTexParameteri(3553, 10240, 9729);
        matrixStack.pushMatrix();
        matrixStack.translate(256.0f, 256.0f, 0.0f);
        if (!this.options.rotates) {
            matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees((float)(-this.northRotate)));
        } else {
            matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.direction));
        }
        matrixStack.translate(-256.0f, -256.0f, 0.0f);
        matrixStack.translate(-this.percentX * 512.0f / 64.0f, this.percentY * 512.0f / 64.0f, 0.0f);
        RenderSystem.applyModelViewMatrix();
        OpenGL.Utils.drawPre();
        OpenGL.Utils.ldrawthree(0.0, 512.0, 1.0, 0.0f, 0.0f);
        OpenGL.Utils.ldrawthree(512.0, 512.0, 1.0, 1.0f, 0.0f);
        OpenGL.Utils.ldrawthree(512.0, 0.0, 1.0, 1.0f, 1.0f);
        OpenGL.Utils.ldrawthree(0.0, 0.0, 1.0, 0.0f, 1.0f);
        OpenGL.Utils.drawPost();
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        OpenGL.glDepthMask(true);
        OpenGL.glEnable(2929);
        OpenGL.Utils.unbindFramebuffer();
        OpenGL.glViewport(0, 0, VoxelConstants.getMinecraft().method_22683().method_4489(), VoxelConstants.getMinecraft().method_22683().method_4506());
        matrixStack.popMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)minimapProjectionMatrix, (class_8251)class_8251.field_43360);
        matrixStack.pushMatrix();
        OpenGL.glBlendFunc(770, 0);
        OpenGL.Utils.disp2(OpenGL.Utils.fboTextureId);
        double guiScale = (double)VoxelConstants.getMinecraft().method_22683().method_4489() / (double)this.scWidth;
        minTablistOffset = guiScale * 63.0;
        OpenGL.glEnable(3089);
        OpenGL.glScissor((int)(guiScale * (double)(x - 32)), (int)(guiScale * ((double)(this.scHeight - y) - 32.0)), (int)(guiScale * 64.0), (int)(guiScale * 63.0));
        OpenGL.Utils.drawPre();
        OpenGL.Utils.setMapWithScale(x, y, scale);
        OpenGL.Utils.drawPost();
        OpenGL.glDisable(3089);
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        OpenGL.glBlendFunc(770, 771);
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.options.squareMap) {
            this.drawSquareMapFrame(x, y);
        } else {
            this.drawRoundMapFrame(x, y);
        }
        double lastXDouble = GameVariableAccessShim.xCoordDouble();
        double lastZDouble = GameVariableAccessShim.zCoordDouble();
        TextureAtlas textureAtlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
        OpenGL.Utils.disp2(textureAtlas.method_4624());
        OpenGL.glEnable(3042);
        OpenGL.glBlendFunc(770, 771);
        OpenGL.glDisable(2929);
        if (VoxelMap.mapOptions.waypointsAllowed) {
            Waypoint highlightedPoint = this.waypointManager.getHighlightedWaypoint();
            for (Waypoint pt : this.waypointManager.getWaypoints()) {
                double distanceSq;
                if (!pt.isActive() && pt != highlightedPoint || !((distanceSq = pt.getDistanceSqToEntity(VoxelConstants.getMinecraft().method_1560())) < (double)(this.options.maxWaypointDisplayDistance * this.options.maxWaypointDisplayDistance)) && this.options.maxWaypointDisplayDistance >= 0 && pt != highlightedPoint) continue;
                this.drawWaypoint(matrixStack, pt, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, null, null, null, null);
            }
            if (highlightedPoint != null) {
                this.drawWaypoint(matrixStack, highlightedPoint, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
        }
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawWaypoint(Matrix4fStack matrixStack, Waypoint pt, TextureAtlas textureAtlas, int x, int y, int scScale, double lastXDouble, double lastZDouble, Sprite icon, Float r, Float g, Float b) {
        boolean far;
        boolean uprightIcon;
        boolean bl = uprightIcon = icon != null;
        if (r == null) {
            r = Float.valueOf(pt.red);
        }
        if (g == null) {
            g = Float.valueOf(pt.green);
        }
        if (b == null) {
            b = Float.valueOf(pt.blue);
        }
        double wayX = lastXDouble - (double)pt.getX() - 0.5;
        double wayY = lastZDouble - (double)pt.getZ() - 0.5;
        float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
        float hypot = (float)Math.sqrt(wayX * wayX + wayY * wayY);
        locate = this.options.rotates ? (locate += this.direction) : (locate -= (float)this.northRotate);
        hypot = (float)((double)hypot / this.zoomScaleAdjusted);
        if (this.options.squareMap) {
            double radLocate = Math.toRadians(locate);
            double dispX = (double)hypot * Math.cos(radLocate);
            double dispY = (double)hypot * Math.sin(radLocate);
            boolean bl2 = far = Math.abs(dispX) > 28.5 || Math.abs(dispY) > 28.5;
            if (far) {
                hypot = (float)((double)hypot / Math.max(Math.abs(dispX), Math.abs(dispY)) * 30.0);
            }
        } else {
            boolean bl3 = far = hypot >= 31.0f;
            if (far) {
                hypot = 34.0f;
            }
        }
        boolean target = false;
        if (far) {
            try {
                if (icon == null) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + "Small.png");
                    if (icon == textureAtlas.getMissingImage()) {
                        icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/markerSmall.png");
                    }
                } else {
                    target = true;
                }
                matrixStack.pushMatrix();
                OpenGL.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), !pt.enabled && !target ? 0.3f : 1.0f);
                matrixStack.translate((float)x, (float)y, 0.0f);
                matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(-locate));
                if (uprightIcon) {
                    matrixStack.translate(0.0f, -hypot, 0.0f);
                    matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(locate));
                    matrixStack.translate((float)(-x), (float)(-y), 0.0f);
                } else {
                    matrixStack.translate((float)(-x), (float)(-y), 0.0f);
                    matrixStack.translate(0.0f, -hypot, 0.0f);
                }
                RenderSystem.applyModelViewMatrix();
                OpenGL.glTexParameteri(3553, 10241, 9729);
                OpenGL.glTexParameteri(3553, 10240, 9729);
                OpenGL.Utils.drawPre();
                OpenGL.Utils.setMap(icon, x, y, 16.0f);
                OpenGL.Utils.drawPost();
            }
            catch (Exception var40) {
                this.error = "Error: marker overlay not found!";
            }
            finally {
                matrixStack.popMatrix();
                RenderSystem.applyModelViewMatrix();
            }
        } else {
            try {
                if (icon == null) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + "Small.png");
                    if (icon == textureAtlas.getMissingImage()) {
                        icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypointSmall.png");
                    }
                } else {
                    target = true;
                }
                matrixStack.pushMatrix();
                OpenGL.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), !pt.enabled && !target ? 0.3f : 1.0f);
                matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(-locate));
                matrixStack.translate(0.0f, -hypot, 0.0f);
                matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(-(-locate)));
                RenderSystem.applyModelViewMatrix();
                OpenGL.glTexParameteri(3553, 10241, 9729);
                OpenGL.glTexParameteri(3553, 10240, 9729);
                OpenGL.Utils.drawPre();
                OpenGL.Utils.setMap(icon, x, y, 16.0f);
                OpenGL.Utils.drawPost();
            }
            catch (Exception var42) {
                this.error = "Error: waypoint overlay not found!";
            }
            finally {
                matrixStack.popMatrix();
                RenderSystem.applyModelViewMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArrow(Matrix4fStack matrixStack, int x, int y) {
        try {
            RenderSystem.setShader(class_757::method_34542);
            matrixStack.pushMatrix();
            OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            OpenGL.glBlendFunc(770, 771);
            OpenGL.Utils.img2(this.arrowResourceLocation);
            OpenGL.glTexParameteri(3553, 10241, 9729);
            OpenGL.glTexParameteri(3553, 10240, 9729);
            matrixStack.translate((float)x, (float)y, 0.0f);
            matrixStack.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.options.rotates && !this.fullscreenMap ? 0.0f : this.direction + (float)this.northRotate));
            matrixStack.translate((float)(-x), (float)(-y), 0.0f);
            RenderSystem.applyModelViewMatrix();
            OpenGL.Utils.drawPre();
            OpenGL.Utils.setMap(x, y, 16);
            OpenGL.Utils.drawPost();
        }
        catch (Exception var8) {
            this.error = "Error: minimap arrow not found!";
        }
        finally {
            matrixStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMapFull(class_332 drawContext, int scWidth, int scHeight) {
        class_4587 matrixStack = drawContext.method_51448();
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.mapImages[this.zoom].write();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        RenderSystem.setShader(class_757::method_34542);
        OpenGL.Utils.disp2(this.mapImages[this.zoom].getIndex());
        OpenGL.glTexParameteri(3553, 10241, 9987);
        OpenGL.glTexParameteri(3553, 10240, 9729);
        matrixStack.method_22903();
        matrixStack.method_22904((double)((float)scWidth / 2.0f), (double)((float)scHeight / 2.0f), -0.0);
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.northRotate));
        matrixStack.method_22904((double)(-((float)scWidth / 2.0f)), (double)(-((float)scHeight / 2.0f)), -0.0);
        RenderSystem.applyModelViewMatrix();
        OpenGL.glDisable(2929);
        OpenGL.Utils.drawPre();
        int left = scWidth / 2 - 128;
        int top = scHeight / 2 - 128;
        OpenGL.Utils.ldrawone(left, top + 256, 160.0, 0.0f, 1.0f);
        OpenGL.Utils.ldrawone(left + 256, top + 256, 160.0, 1.0f, 1.0f);
        OpenGL.Utils.ldrawone(left + 256, top, 160.0, 1.0f, 0.0f);
        OpenGL.Utils.ldrawone(left, top, 160.0, 0.0f, 0.0f);
        OpenGL.Utils.drawPost();
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        if (this.options.biomeOverlay != 0) {
            double factor = Math.pow(2.0, 3 - this.zoom);
            int minimumSize = (int)Math.pow(2.0, this.zoom);
            minimumSize *= minimumSize;
            ArrayList<AbstractMapData.BiomeLabel> labels = this.mapData[this.zoom].getBiomeLabels();
            OpenGL.glDisable(2929);
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.0, 1160.0);
            RenderSystem.applyModelViewMatrix();
            for (AbstractMapData.BiomeLabel o : labels) {
                if (o.segmentSize <= minimumSize) continue;
                String name = o.name;
                int nameWidth = this.chkLen(name);
                float x = (float)((double)o.x * factor);
                float z = (float)((double)o.z * factor);
                if (this.options.oldNorth) {
                    this.write(drawContext, name, (float)(left + 256) - z - (float)nameWidth / 2.0f, (float)top + x - 3.0f, 0xFFFFFF);
                    continue;
                }
                this.write(drawContext, name, (float)left + x - (float)nameWidth / 2.0f, (float)top + z - 3.0f, 0xFFFFFF);
            }
            matrixStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            OpenGL.glEnable(2929);
        }
    }

    private void drawSquareMapFrame(int x, int y) {
        try {
            OpenGL.Utils.disp2(this.mapImageInt);
            OpenGL.glTexParameteri(3553, 10241, 9729);
            OpenGL.glTexParameteri(3553, 10240, 9729);
            OpenGL.glTexParameteri(3553, 10242, 33071);
            OpenGL.glTexParameteri(3553, 10243, 33071);
            OpenGL.Utils.drawPre();
            OpenGL.Utils.setMap(x, y, 128);
            OpenGL.Utils.drawPost();
        }
        catch (Exception var4) {
            this.error = "error: minimap overlay not found!";
        }
    }

    private void loadMapImage() {
        if (this.mapImageInt != -1) {
            OpenGL.Utils.glah(this.mapImageInt);
        }
        try {
            InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(class_2960.method_60655((String)"voxelmap", (String)"images/squaremap.png")).get()).method_14482();
            BufferedImage mapImage = ImageIO.read(is);
            is.close();
            this.mapImageInt = OpenGL.Utils.tex(mapImage);
        }
        catch (Exception var8) {
            try {
                InputStream is = ((class_3298)VoxelConstants.getMinecraft().method_1478().method_14486(class_2960.method_60654((String)"textures/map/map_background.png")).get()).method_14482();
                BufferedImage tpMap = ImageIO.read(is);
                is.close();
                BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
                Graphics2D gfx = mapImage.createGraphics();
                gfx.drawImage((Image)tpMap, 0, 0, null);
                int border = mapImage.getWidth() * 8 / 128;
                gfx.setComposite(AlphaComposite.Clear);
                gfx.fillRect(border, border, mapImage.getWidth() - border * 2, mapImage.getHeight() - border * 2);
                gfx.dispose();
                this.mapImageInt = OpenGL.Utils.tex(mapImage);
            }
            catch (Exception var7) {
                VoxelConstants.getLogger().warn("Error loading texture pack's map image: " + var7.getLocalizedMessage());
            }
        }
    }

    private void drawRoundMapFrame(int x, int y) {
        try {
            OpenGL.Utils.img2(this.roundmapResourceLocation);
            OpenGL.glTexParameteri(3553, 10241, 9729);
            OpenGL.glTexParameteri(3553, 10240, 9729);
            OpenGL.Utils.drawPre();
            OpenGL.Utils.setMap(x, y, 128);
            OpenGL.Utils.drawPost();
        }
        catch (Exception var4) {
            this.error = "Error: minimap overlay not found!";
        }
    }

    private void drawDirections(class_332 drawContext, int x, int y) {
        float distance;
        class_4587 matrixStack = drawContext.method_51448();
        boolean unicode = (Boolean)VoxelConstants.getMinecraft().field_1690.method_42437().method_41753();
        float scale = unicode ? 0.65f : 0.5f;
        float rotate = this.options.rotates ? -this.direction - 90.0f - (float)this.northRotate : -90.0f;
        if (this.options.squareMap) {
            if (this.options.rotates) {
                float tempdir = this.direction % 90.0f;
                tempdir = 45.0f - Math.abs(45.0f - tempdir);
                distance = (float)(33.5 / (double)scale / Math.cos(Math.toRadians(tempdir)));
            } else {
                distance = 33.5f / scale;
            }
        } else {
            distance = 32.0f / scale;
        }
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)distance * Math.sin(Math.toRadians(-((double)rotate - 90.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate - 90.0))), 100.0);
        this.write(drawContext, "N", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)distance * Math.sin(Math.toRadians(-rotate)), (double)distance * Math.cos(Math.toRadians(-rotate)), 10.0);
        this.write(drawContext, "E", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)distance * Math.sin(Math.toRadians(-((double)rotate + 90.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate + 90.0))), 10.0);
        this.write(drawContext, "S", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22905(scale, scale, 1.0f);
        matrixStack.method_22904((double)distance * Math.sin(Math.toRadians(-((double)rotate + 180.0))), (double)distance * Math.cos(Math.toRadians(-((double)rotate + 180.0))), 10.0);
        this.write(drawContext, "W", (float)x / scale - 2.0f, (float)y / scale - 4.0f, 0xFFFFFF);
        matrixStack.method_22909();
    }

    private void showCoords(class_332 drawContext, int x, int y) {
        class_4587 matrixStack = drawContext.method_51448();
        int textStart = y > this.scHeight - 37 - 32 - 4 - 15 ? y - 32 - 4 - 9 : y + 32 + 4;
        if (!this.options.hide && !this.fullscreenMap) {
            boolean unicode = (Boolean)VoxelConstants.getMinecraft().field_1690.method_42437().method_41753();
            float scale = unicode ? 0.65f : 0.5f;
            matrixStack.method_22903();
            matrixStack.method_22905(scale, scale, 1.0f);
            Object xy = this.dCoord(GameVariableAccessShim.xCoord()) + ", " + this.dCoord(GameVariableAccessShim.zCoord());
            int m = this.chkLen((String)xy) / 2;
            this.write(drawContext, (String)xy, (float)x / scale - (float)m, (float)textStart / scale, 0xFFFFFF);
            xy = Integer.toString(GameVariableAccessShim.yCoord());
            m = this.chkLen((String)xy) / 2;
            this.write(drawContext, (String)xy, (float)x / scale - (float)m, (float)textStart / scale + 10.0f, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(drawContext, this.error, (float)x / scale - (float)m, (float)textStart / scale + 19.0f, 0xFFFFFF);
            }
            matrixStack.method_22909();
        } else {
            int heading = (int)(this.direction + (float)this.northRotate);
            if (heading > 360) {
                heading -= 360;
            }
            String ns = "";
            String ew = "";
            if ((double)heading > 292.5 || (double)heading <= 67.5) {
                ns = "N";
            } else if ((double)heading > 112.5 && (double)heading <= 247.5) {
                ns = "S";
            }
            if ((double)heading > 22.5 && (double)heading <= 157.5) {
                ew = "E";
            } else if ((double)heading > 202.5 && (double)heading <= 337.5) {
                ew = "W";
            }
            String stats = "(" + this.dCoord(GameVariableAccessShim.xCoord()) + ", " + GameVariableAccessShim.yCoord() + ", " + this.dCoord(GameVariableAccessShim.zCoord()) + ") " + heading + "' " + ns + ew;
            int m = this.chkLen(stats) / 2;
            this.write(drawContext, stats, (float)this.scWidth / 2.0f - (float)m, 5.0f, 0xFFFFFF);
            if (this.ztimer > 0) {
                m = this.chkLen(this.error) / 2;
                this.write(drawContext, this.error, (float)this.scWidth / 2.0f - (float)m, 15.0f, 0xFFFFFF);
            }
        }
    }

    private String dCoord(int paramInt1) {
        if (paramInt1 < 0) {
            return "-" + Math.abs(paramInt1);
        }
        return paramInt1 > 0 ? "+" + paramInt1 : " " + paramInt1;
    }

    private int chkLen(String string) {
        return this.fontRenderer.method_1727(string);
    }

    private void write(class_332 drawContext, String text, float x, float y, int color) {
        this.write(drawContext, class_2561.method_30163((String)text), x, y, color);
    }

    private int chkLen(class_2561 text) {
        return this.fontRenderer.method_27525((class_5348)text);
    }

    private void write(class_332 drawContext, class_2561 text, float x, float y, int color) {
        drawContext.method_27535(this.fontRenderer, text, (int)x, (int)y, color);
    }

    private void drawWelcomeScreen(class_332 drawContext, int scWidth, int scHeight) {
        int height;
        if (this.welcomeText[1] == null || this.welcomeText[1].getString().equals("minimap.ui.welcome2")) {
            String zmodver = ((ModContainer)FabricLoader.getInstance().getModContainer("voxelmap").get()).getMetadata().getVersion().getFriendlyString();
            this.welcomeText[0] = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"VoxelMap! ").method_27692(class_124.field_1061)).method_27693(zmodver + " ").method_10852((class_2561)class_2561.method_43471((String)"minimap.ui.welcome1"));
            this.welcomeText[1] = class_2561.method_43471((String)"minimap.ui.welcome2");
            this.welcomeText[2] = class_2561.method_43471((String)"minimap.ui.welcome3");
            this.welcomeText[3] = class_2561.method_43471((String)"minimap.ui.welcome4");
            this.welcomeText[4] = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43472((String)this.options.keyBindZoom.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)"minimap.ui.welcome5a")).method_27693(", ").method_10852((class_2561)class_2561.method_43472((String)this.options.keyBindMenu.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)"minimap.ui.welcome5b"));
            this.welcomeText[5] = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43472((String)this.options.keyBindFullscreen.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)"minimap.ui.welcome6"));
            this.welcomeText[6] = class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43472((String)this.options.keyBindWaypoint.method_1431()).method_27692(class_124.field_1075)).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)"minimap.ui.welcome7"));
            this.welcomeText[7] = this.options.keyBindZoom.method_16007().method_27661().method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)"minimap.ui.welcome8").method_27692(class_124.field_1080));
        }
        OpenGL.glBlendFunc(770, 771);
        int maxSize = 0;
        int border = 2;
        class_2561 head = this.welcomeText[0];
        for (height = 1; height < this.welcomeText.length - 1; ++height) {
            if (this.chkLen(this.welcomeText[height]) <= maxSize) continue;
            maxSize = this.chkLen(this.welcomeText[height]);
        }
        int title = this.chkLen(head);
        int centerX = (int)((double)(scWidth + 5) / 2.0);
        int centerY = (int)((double)(scHeight + 5) / 2.0);
        class_2561 hide = this.welcomeText[this.welcomeText.length - 1];
        int footer = this.chkLen(hide);
        int leftX = centerX - title / 2 - border;
        int rightX = centerX + title / 2 + border;
        int topY = centerY - (height - 1) / 2 * 10 - border - 20;
        int botY = centerY - (height - 1) / 2 * 10 + border - 10;
        this.drawBox(drawContext, leftX, rightX, topY, botY);
        leftX = centerX - maxSize / 2 - border;
        rightX = centerX + maxSize / 2 + border;
        topY = centerY - (height - 1) / 2 * 10 - border;
        botY = centerY + (height - 1) / 2 * 10 + border;
        this.drawBox(drawContext, leftX, rightX, topY, botY);
        leftX = centerX - footer / 2 - border;
        rightX = centerX + footer / 2 + border;
        topY = centerY + (height - 1) / 2 * 10 - border + 10;
        botY = centerY + (height - 1) / 2 * 10 + border + 20;
        this.drawBox(drawContext, leftX, rightX, topY, botY);
        drawContext.method_27535(this.fontRenderer, head, centerX - title / 2, centerY - (height - 1) * 10 / 2 - 19, Color.WHITE.getRGB());
        for (int n = 1; n < height; ++n) {
            drawContext.method_27535(this.fontRenderer, this.welcomeText[n], centerX - maxSize / 2, centerY - (height - 1) * 10 / 2 + n * 10 - 9, Color.WHITE.getRGB());
        }
        drawContext.method_27535(this.fontRenderer, hide, centerX - footer / 2, (scHeight + 5) / 2 + (height - 1) * 10 / 2 + 11, Color.WHITE.getRGB());
    }

    private void drawBox(class_332 drawContext, int leftX, int rightX, int topY, int botY) {
        double e = (Double)VoxelConstants.getMinecraft().field_1690.method_42550().method_41753();
        int v = (int)(255.0 * e);
        drawContext.method_25294(leftX, topY, rightX, botY, v << 24);
    }

    public static double getMinTablistOffset() {
        return minTablistOffset;
    }

    public static float getStatusIconOffset() {
        return statusIconOffset;
    }

    static {
        statusIconOffset = 0.0f;
    }
}

