/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.gson.Gson;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.packets.VoxelmapSettingsS2C;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_310;

public class VoxelmapSettingsChannelHandler
implements ClientPlayNetworking.PlayPayloadHandler<VoxelmapSettingsS2C>,
ClientConfigurationNetworking.ConfigurationPayloadHandler<VoxelmapSettingsS2C> {
    public VoxelmapSettingsChannelHandler() {
        PayloadTypeRegistry.playS2C().register(VoxelmapSettingsS2C.PACKET_ID, VoxelmapSettingsS2C.PACKET_CODEC);
        PayloadTypeRegistry.configurationS2C().register(VoxelmapSettingsS2C.PACKET_ID, VoxelmapSettingsS2C.PACKET_CODEC);
        ClientPlayNetworking.registerGlobalReceiver(VoxelmapSettingsS2C.PACKET_ID, (ClientPlayNetworking.PlayPayloadHandler)this);
        ClientConfigurationNetworking.registerGlobalReceiver(VoxelmapSettingsS2C.PACKET_ID, (ClientConfigurationNetworking.ConfigurationPayloadHandler)this);
    }

    public void receive(VoxelmapSettingsS2C payload, ClientConfigurationNetworking.Context context) {
        this.parsePacket(payload);
    }

    public void receive(VoxelmapSettingsS2C payload, ClientPlayNetworking.Context context) {
        this.parsePacket(payload);
    }

    private void parsePacket(VoxelmapSettingsS2C packet) {
        Map settings = (Map)new Gson().fromJson(packet.settingsJson(), Map.class);
        block24: for (Map.Entry entry : settings.entrySet()) {
            String setting = (String)entry.getKey();
            Object value = entry.getValue();
            switch (setting) {
                case "worldName": {
                    if (value instanceof String) {
                        String worldName = (String)value;
                        class_310.method_1551().execute(() -> {
                            VoxelConstants.getLogger().info("Received world name from settings: " + worldName);
                            VoxelConstants.getVoxelMapInstance().newSubWorldName(worldName, true);
                        });
                        continue block24;
                    }
                    VoxelConstants.getLogger().warn("Invalid world name: " + String.valueOf(value));
                    continue block24;
                }
                case "radarAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarAllowed = (Boolean)value;
                    continue block24;
                }
                case "radarMobsAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarMobsAllowed = (Boolean)value;
                    continue block24;
                }
                case "radarPlayersAllowed": {
                    VoxelConstants.getVoxelMapInstance().getRadarOptions().radarPlayersAllowed = (Boolean)value;
                    continue block24;
                }
                case "cavesAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().cavesAllowed = (Boolean)value;
                    continue block24;
                }
                case "minimapAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().minimapAllowed = (Boolean)value;
                    continue block24;
                }
                case "worldmapAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().worldmapAllowed = (Boolean)value;
                    continue block24;
                }
                case "waypointsAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().waypointsAllowed = (Boolean)value;
                    continue block24;
                }
                case "deathWaypointAllowed": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().deathWaypointAllowed = (Boolean)value;
                    continue block24;
                }
                case "teleportCommand": {
                    VoxelConstants.getVoxelMapInstance().getMapOptions().serverTeleportCommand = (String)value;
                    continue block24;
                }
            }
            VoxelConstants.getLogger().warn("Unknown configuration option " + setting);
        }
    }
}

