/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.interfaces;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2680;

public abstract class AbstractMapData {
    protected int width;
    protected int height;
    protected final Object dataLock = new Object();
    private final Object labelLock = new Object();
    public Point[][] points;
    public ArrayList<Segment> segments;
    private final ArrayList<BiomeLabel> labels = new ArrayList();

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segmentBiomes() {
        this.points = new Point[this.width][this.height];
        this.segments = new ArrayList();
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.height; ++z) {
                this.points[x][z] = new Point(x, z, this.getBiome(x, z));
            }
        }
        Object object = this.dataLock;
        synchronized (object) {
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.height; ++z) {
                    if (this.points[x][z].inSegment) continue;
                    long startTime = System.nanoTime();
                    if (this.points[x][z].biomeID == null) {
                        VoxelConstants.getLogger().warn("no biome segment!");
                    }
                    Segment segment = new Segment(this.points[x][z]);
                    this.segments.add(segment);
                    segment.flood();
                    if (this.points[x][z].biomeID != null) continue;
                    VoxelConstants.getLogger().warn("created in " + (System.nanoTime() - startTime));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findCenterOfSegments(boolean horizontalBias) {
        if (this.segments != null) {
            for (Segment segment : this.segments) {
                if (segment.biomeID == null) continue;
                segment.calculateCenter(horizontalBias);
            }
        }
        Object object = this.labelLock;
        synchronized (object) {
            this.labels.clear();
            if (this.segments != null) {
                for (Segment segment : this.segments) {
                    if (segment.biomeID == null) continue;
                    BiomeLabel label = new BiomeLabel();
                    label.biomeID = segment.biomeID;
                    label.name = segment.name;
                    label.segmentSize = segment.memberPoints.size();
                    label.x = segment.centerX;
                    label.z = segment.centerZ;
                    this.labels.add(label);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<BiomeLabel> getBiomeLabels() {
        Object object = this.labelLock;
        synchronized (object) {
            return new ArrayList<BiomeLabel>(this.labels);
        }
    }

    public abstract int getHeight(int var1, int var2);

    public abstract class_2680 getBlockstate(int var1, int var2);

    public abstract int getBiomeTint(int var1, int var2);

    public abstract int getLight(int var1, int var2);

    public abstract int getOceanFloorHeight(int var1, int var2);

    public abstract class_2680 getOceanFloorBlockstate(int var1, int var2);

    public abstract int getOceanFloorBiomeTint(int var1, int var2);

    public abstract int getOceanFloorLight(int var1, int var2);

    public abstract int getTransparentHeight(int var1, int var2);

    public abstract class_2680 getTransparentBlockstate(int var1, int var2);

    public abstract int getTransparentBiomeTint(int var1, int var2);

    public abstract int getTransparentLight(int var1, int var2);

    public abstract int getFoliageHeight(int var1, int var2);

    public abstract class_2680 getFoliageBlockstate(int var1, int var2);

    public abstract int getFoliageBiomeTint(int var1, int var2);

    public abstract int getFoliageLight(int var1, int var2);

    public abstract class_1959 getBiome(int var1, int var2);

    public abstract void setHeight(int var1, int var2, int var3);

    public abstract void setBlockstate(int var1, int var2, class_2680 var3);

    public abstract void setBiomeTint(int var1, int var2, int var3);

    public abstract void setLight(int var1, int var2, int var3);

    public abstract void setOceanFloorHeight(int var1, int var2, int var3);

    public abstract void setOceanFloorBlockstate(int var1, int var2, class_2680 var3);

    public abstract void setOceanFloorBiomeTint(int var1, int var2, int var3);

    public abstract void setOceanFloorLight(int var1, int var2, int var3);

    public abstract void setTransparentHeight(int var1, int var2, int var3);

    public abstract void setTransparentBlockstate(int var1, int var2, class_2680 var3);

    public abstract void setTransparentBiomeTint(int var1, int var2, int var3);

    public abstract void setTransparentLight(int var1, int var2, int var3);

    public abstract void setFoliageHeight(int var1, int var2, int var3);

    public abstract void setFoliageBlockstate(int var1, int var2, class_2680 var3);

    public abstract void setFoliageBiomeTint(int var1, int var2, int var3);

    public abstract void setFoliageLight(int var1, int var2, int var3);

    public abstract void setBiome(int var1, int var2, class_1959 var3);

    public abstract void moveX(int var1);

    public abstract void moveZ(int var1);

    private static final class Point {
        public final int x;
        public final int z;
        public boolean inSegment;
        public boolean isCandidate;
        public int layer = -1;
        public final class_1959 biomeID;

        private Point(int x, int z, class_1959 biomeID) {
            this.x = x;
            this.z = z;
            if (biomeID == null) {
                this.inSegment = true;
            }
            this.biomeID = biomeID;
        }
    }

    public class Segment {
        public final ArrayList<Point> memberPoints;
        ArrayList<Point> currentShell;
        public final class_1959 biomeID;
        public String name;
        public int centerX;
        public int centerZ;

        public Segment(Point point) {
            this.biomeID = point.biomeID;
            if (this.biomeID != null) {
                this.name = BiomeRepository.getName(this.biomeID);
            }
            this.memberPoints = new ArrayList();
            this.memberPoints.add(point);
            this.currentShell = new ArrayList();
        }

        public void flood() {
            ArrayList<Point> candidatePoints = new ArrayList<Point>();
            candidatePoints.add(this.memberPoints.remove(0));
            while (!candidatePoints.isEmpty()) {
                Point neighbor;
                Point point = (Point)candidatePoints.remove(0);
                point.isCandidate = false;
                if (point.biomeID != this.biomeID) continue;
                this.memberPoints.add(point);
                point.inSegment = true;
                boolean edge = false;
                if (point.x < AbstractMapData.this.width - 1) {
                    neighbor = AbstractMapData.this.points[point.x + 1][point.z];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biomeID != point.biomeID) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (point.x > 0) {
                    neighbor = AbstractMapData.this.points[point.x - 1][point.z];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biomeID != point.biomeID) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (point.z < AbstractMapData.this.height - 1) {
                    neighbor = AbstractMapData.this.points[point.x][point.z + 1];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biomeID != point.biomeID) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (point.z > 0) {
                    neighbor = AbstractMapData.this.points[point.x][point.z - 1];
                    if (!neighbor.inSegment && !neighbor.isCandidate) {
                        candidatePoints.add(neighbor);
                        neighbor.isCandidate = true;
                    }
                    if (neighbor.biomeID != point.biomeID) {
                        edge = true;
                    }
                } else {
                    edge = true;
                }
                if (!edge) continue;
                point.layer = 0;
                this.currentShell.add(point);
            }
        }

        public void calculateCenter(boolean horizontalBias) {
            this.calculateCenterOfMass();
            this.morphologicallyErode(horizontalBias);
        }

        public void calculateCenterOfMass() {
            this.calculateCenterOfMass(this.memberPoints);
        }

        public void calculateCenterOfMass(List<Point> points) {
            this.centerX = 0;
            this.centerZ = 0;
            for (Point point : points) {
                this.centerX += point.x;
                this.centerZ += point.z;
            }
            this.centerX /= points.size();
            this.centerZ /= points.size();
        }

        public void calculateClosestPointToCenter(List<Point> points) {
            int distanceSquared = AbstractMapData.this.width * AbstractMapData.this.width + AbstractMapData.this.height * AbstractMapData.this.height;
            Point centerPoint = null;
            for (Point point : points) {
                int pointDistanceSquared = (point.x - this.centerX) * (point.x - this.centerX) + (point.z - this.centerZ) * (point.z - this.centerZ);
                if (pointDistanceSquared >= distanceSquared) continue;
                distanceSquared = pointDistanceSquared;
                centerPoint = point;
            }
            this.centerX = centerPoint.x;
            this.centerZ = centerPoint.z;
        }

        public void morphologicallyErode(boolean horizontalBias) {
            float labelWidth = VoxelConstants.getMinecraft().field_1772.method_1727(this.name) + 8;
            float multi = (float)AbstractMapData.this.width / 32.0f;
            float shellWidth = 2.0f;
            float labelPadding = labelWidth / 16.0f * multi / shellWidth;
            int layer = 0;
            while (!this.currentShell.isEmpty() && (float)layer < labelPadding) {
                this.currentShell = this.getNextShell(this.currentShell, ++layer, horizontalBias);
            }
            if (!this.currentShell.isEmpty()) {
                ArrayList<Point> remainingPoints = new ArrayList<Point>();
                for (Point point : this.memberPoints) {
                    if (point.layer >= 0 && point.layer != layer) continue;
                    remainingPoints.add(point);
                }
                this.calculateClosestPointToCenter(remainingPoints);
            }
        }

        public ArrayList<Point> getNextShell(List<Point> pointsToCheck, int layer, boolean horizontalBias) {
            int layerWidth = horizontalBias ? 2 : 1;
            int layerHeight = horizontalBias ? 1 : 2;
            ArrayList<Point> nextShell = new ArrayList<Point>();
            for (Point point : pointsToCheck) {
                Point neighbor;
                int t;
                boolean foundEdge;
                if (point.x < AbstractMapData.this.width - layerWidth) {
                    foundEdge = false;
                    for (t = layerWidth; t > 0; --t) {
                        neighbor = AbstractMapData.this.points[point.x + t][point.z];
                        if (neighbor.biomeID != point.biomeID || neighbor.layer >= 0) continue;
                        neighbor.layer = layer;
                        if (foundEdge) continue;
                        foundEdge = true;
                        nextShell.add(neighbor);
                    }
                }
                if (point.x >= layerWidth) {
                    foundEdge = false;
                    for (t = layerWidth; t > 0; --t) {
                        neighbor = AbstractMapData.this.points[point.x - t][point.z];
                        if (neighbor.biomeID != point.biomeID || neighbor.layer >= 0) continue;
                        neighbor.layer = layer;
                        if (foundEdge) continue;
                        foundEdge = true;
                        nextShell.add(neighbor);
                    }
                }
                if (point.z < AbstractMapData.this.height - layerHeight) {
                    foundEdge = false;
                    for (t = layerHeight; t > 0; --t) {
                        neighbor = AbstractMapData.this.points[point.x][point.z + t];
                        if (neighbor.biomeID != point.biomeID || neighbor.layer >= 0) continue;
                        neighbor.layer = layer;
                        if (foundEdge) continue;
                        foundEdge = true;
                        nextShell.add(neighbor);
                    }
                }
                if (point.z < layerHeight) continue;
                foundEdge = false;
                for (t = layerHeight; t > 0; --t) {
                    neighbor = AbstractMapData.this.points[point.x][point.z - t];
                    if (neighbor.biomeID != point.biomeID || neighbor.layer >= 0) continue;
                    neighbor.layer = layer;
                    if (foundEdge) continue;
                    foundEdge = true;
                    nextShell.add(neighbor);
                }
            }
            if (nextShell.isEmpty()) {
                this.calculateCenterOfMass(pointsToCheck);
                this.calculateClosestPointToCenter(pointsToCheck);
            }
            return nextShell;
        }
    }

    public static class BiomeLabel {
        public class_1959 biomeID = null;
        public String name = "";
        public int segmentSize;
        public int x;
        public int z;
    }
}

