/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryUtil;

public final class TextureUtilLegacy {
    private static final int DATA_BUFFER_SIZE = 0x400000;
    private static final IntBuffer DATA_BUFFER = MemoryUtil.memCallocInt((int)0x400000);

    private TextureUtilLegacy() {
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        BufferedImage bufferedimage;
        if (imageStream == null) {
            return null;
        }
        try {
            bufferedimage = ImageIO.read(imageStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
        return bufferedimage;
    }

    public static void allocateTexture(int glTextureId, int width, int height) {
        RenderSystem.bindTexture((int)glTextureId);
        RenderSystem.pixelStore((int)3314, (int)0);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        GlStateManager._texImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, null);
    }

    public static void uploadTexture(int glTextureId, int[] zeros, int currentImageWidth, int currentImageHeight) {
        RenderSystem.bindTexture((int)glTextureId);
        TextureUtilLegacy.uploadTextureSub(zeros, currentImageWidth, currentImageHeight, 0, 0);
    }

    public static void uploadSubTexture(int[] textureData, int width, int height, int originX, int originY) {
        TextureUtilLegacy.uploadTextureSub(textureData, width, height, originX, originY);
    }

    private static void copyToBufferPos(int[] imageData, int offset, int length) {
        DATA_BUFFER.clear();
        DATA_BUFFER.put(imageData, offset, length);
        DATA_BUFFER.position(0).limit(length);
    }

    private static void uploadTextureSub(int[] imageData, int width, int height, int originX, int originY) {
        int rowsToCopy;
        RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        RenderSystem.texParameter((int)3553, (int)10242, (int)10497);
        RenderSystem.texParameter((int)3553, (int)10243, (int)10497);
        RenderSystem.pixelStore((int)3314, (int)width);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        int maxRows = 0x400000 / width;
        for (int pos = 0; pos < width * height; pos += width * rowsToCopy) {
            int rowsCopied = pos / width;
            rowsToCopy = Math.min(maxRows, height - rowsCopied);
            int sizeOfCopy = width * rowsToCopy;
            TextureUtilLegacy.copyToBufferPos(imageData, pos, sizeOfCopy);
            GL30C.glTexSubImage2D((int)3553, (int)0, (int)originX, (int)(originY + rowsCopied), (int)width, (int)rowsToCopy, (int)32993, (int)33639, (IntBuffer)DATA_BUFFER);
        }
    }
}

