/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class CompressionUtils {
    private CompressionUtils() {
    }

    public static byte[] compress(byte[] dataToCompress) {
        byte[] byArray;
        Deflater deflater = new Deflater();
        deflater.setLevel(1);
        deflater.setInput(dataToCompress);
        deflater.finish();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(dataToCompress.length);
        try {
            byte[] buffer = new byte[1024];
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            deflater.end();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("IOException should not happen for ByteArrayOutputStream", e);
            }
        }
        outputStream.close();
        return byArray;
    }

    public static byte[] decompress(byte[] dataToDecompress) throws DataFormatException {
        byte[] byArray;
        Inflater inflater = new Inflater();
        inflater.setInput(dataToDecompress);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(dataToDecompress.length);
        try {
            byte[] buffer = new byte[1024];
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            inflater.end();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("IOException should not happen for ByteArrayOutputStream", e);
            }
        }
        outputStream.close();
        return byArray;
    }
}

