/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import java.util.Arrays;
import net.minecraft.class_1959;
import net.minecraft.class_2680;

public class FullMapData
extends AbstractMapData {
    private static final int LAYERS = 17;
    private int[] data;
    private class_1959[] biomes;

    public FullMapData(int width, int height) {
        this.width = width;
        this.height = height;
        this.data = new int[width * height * 17];
        this.biomes = new class_1959[width * height];
        Arrays.fill(this.data, 0);
    }

    public void blank() {
        Arrays.fill(this.data, 0);
    }

    @Override
    public int getHeight(int x, int z) {
        return this.getData(x, z, 0);
    }

    public int getBlockstateID(int x, int z) {
        return this.getData(x, z, 1);
    }

    @Override
    public class_2680 getBlockstate(int x, int z) {
        return this.getStateFromID(this.getData(x, z, 1));
    }

    @Override
    public int getBiomeTint(int x, int z) {
        return this.getData(x, z, 2);
    }

    @Override
    public int getLight(int x, int z) {
        return this.getData(x, z, 3);
    }

    @Override
    public int getOceanFloorHeight(int x, int z) {
        return this.getData(x, z, 4);
    }

    public int getOceanFloorBlockstateID(int x, int z) {
        return this.getData(x, z, 5);
    }

    @Override
    public class_2680 getOceanFloorBlockstate(int x, int z) {
        return this.getStateFromID(this.getData(x, z, 5));
    }

    @Override
    public int getOceanFloorBiomeTint(int x, int z) {
        return this.getData(x, z, 6);
    }

    @Override
    public int getOceanFloorLight(int x, int z) {
        return this.getData(x, z, 7);
    }

    @Override
    public int getTransparentHeight(int x, int z) {
        return this.getData(x, z, 8);
    }

    public int getTransparentBlockstateID(int x, int z) {
        return this.getData(x, z, 9);
    }

    @Override
    public class_2680 getTransparentBlockstate(int x, int z) {
        return this.getStateFromID(this.getData(x, z, 9));
    }

    @Override
    public int getTransparentBiomeTint(int x, int z) {
        return this.getData(x, z, 10);
    }

    @Override
    public int getTransparentLight(int x, int z) {
        return this.getData(x, z, 11);
    }

    @Override
    public int getFoliageHeight(int x, int z) {
        return this.getData(x, z, 12);
    }

    public int getFoliageBlockstateID(int x, int z) {
        return this.getData(x, z, 13);
    }

    @Override
    public class_2680 getFoliageBlockstate(int x, int z) {
        return this.getStateFromID(this.getData(x, z, 13));
    }

    @Override
    public int getFoliageBiomeTint(int x, int z) {
        return this.getData(x, z, 14);
    }

    @Override
    public int getFoliageLight(int x, int z) {
        return this.getData(x, z, 15);
    }

    @Override
    public class_1959 getBiome(int x, int z) {
        return this.biomes[x + z * this.width];
    }

    private int getData(int x, int z, int bit) {
        int index = (x + z * this.width) * 17 + bit;
        return this.data[index];
    }

    @Override
    public void setHeight(int x, int z, int height) {
        this.setData(x, z, 0, height);
    }

    public void setBlockstateID(int x, int z, int id) {
        this.setData(x, z, 1, id);
    }

    @Override
    public void setBlockstate(int x, int z, class_2680 state) {
        this.setData(x, z, 1, this.getIDFromState(state));
    }

    @Override
    public void setBiomeTint(int x, int z, int tint) {
        this.setData(x, z, 2, tint);
    }

    @Override
    public void setLight(int x, int z, int light) {
        this.setData(x, z, 3, light);
    }

    @Override
    public void setOceanFloorHeight(int x, int z, int height) {
        this.setData(x, z, 4, height);
    }

    public void setOceanFloorBlockstateID(int x, int z, int id) {
        this.setData(x, z, 5, id);
    }

    @Override
    public void setOceanFloorBlockstate(int x, int z, class_2680 state) {
        this.setData(x, z, 5, this.getIDFromState(state));
    }

    @Override
    public void setOceanFloorBiomeTint(int x, int z, int tint) {
        this.setData(x, z, 6, tint);
    }

    @Override
    public void setOceanFloorLight(int x, int z, int light) {
        this.setData(x, z, 7, light);
    }

    @Override
    public void setTransparentHeight(int x, int z, int height) {
        this.setData(x, z, 8, height);
    }

    public void setTransparentBlockstateID(int x, int z, int id) {
        this.setData(x, z, 9, id);
    }

    @Override
    public void setTransparentBlockstate(int x, int z, class_2680 state) {
        this.setData(x, z, 9, this.getIDFromState(state));
    }

    @Override
    public void setTransparentBiomeTint(int x, int z, int tint) {
        this.setData(x, z, 10, tint);
    }

    @Override
    public void setTransparentLight(int x, int z, int light) {
        this.setData(x, z, 11, light);
    }

    @Override
    public void setFoliageHeight(int x, int z, int height) {
        this.setData(x, z, 12, height);
    }

    public void setFoliageBlockstateID(int x, int z, int id) {
        this.setData(x, z, 13, id);
    }

    @Override
    public void setFoliageBlockstate(int x, int z, class_2680 state) {
        this.setData(x, z, 13, this.getIDFromState(state));
    }

    @Override
    public void setFoliageBiomeTint(int x, int z, int tint) {
        this.setData(x, z, 14, tint);
    }

    @Override
    public void setFoliageLight(int x, int z, int light) {
        this.setData(x, z, 15, light);
    }

    @Override
    public void setBiome(int x, int z, class_1959 biome) {
        this.biomes[x + z * this.width] = biome;
    }

    private void setData(int x, int z, int bit, int value) {
        int index = (x + z * this.width) * 17 + bit;
        this.data[index] = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveX(int x) {
        Object object = this.dataLock;
        synchronized (object) {
            if (x > 0) {
                System.arraycopy(this.data, x * 17, this.data, 0, this.data.length - x * 17);
                System.arraycopy(this.biomes, x, this.biomes, 0, this.biomes.length - x);
            } else if (x < 0) {
                System.arraycopy(this.data, 0, this.data, -x * 17, this.data.length + x * 17);
                System.arraycopy(this.biomes, 0, this.biomes, -x, this.biomes.length + x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveZ(int z) {
        Object object = this.dataLock;
        synchronized (object) {
            if (z > 0) {
                System.arraycopy(this.data, z * this.width * 17, this.data, 0, this.data.length - z * this.width * 17);
                System.arraycopy(this.biomes, z * this.width, this.biomes, 0, this.biomes.length - z * this.width);
            } else if (z < 0) {
                System.arraycopy(this.data, 0, this.data, -z * this.width * 17, this.data.length + z * this.width * 17);
                System.arraycopy(this.biomes, 0, this.biomes, -z * this.width, this.biomes.length + z * this.width);
            }
        }
    }

    private int getIDFromState(class_2680 blockState) {
        return BlockRepository.getStateId(blockState);
    }

    private class_2680 getStateFromID(int id) {
        return BlockRepository.getStateById(id);
    }
}

