/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import java.io.Serializable;
import java.util.Locale;
import java.util.TreeSet;
import net.minecraft.class_1297;

public class Waypoint
implements Serializable,
Comparable<Waypoint> {
    private static final long serialVersionUID = 8136790917447997951L;
    public String name;
    public String imageSuffix;
    public String world;
    public final TreeSet<DimensionContainer> dimensions;
    public int x;
    public int z;
    public int y;
    public boolean enabled;
    public boolean inWorld = true;
    public boolean inDimension = true;
    public float red;
    public float green;
    public float blue;

    public Waypoint(String name, int x, int z, int y, boolean enabled, float red, float green, float blue, String suffix, String world, TreeSet<DimensionContainer> dimensions) {
        this.name = name;
        this.x = x;
        this.z = z;
        this.y = y;
        this.enabled = enabled;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.imageSuffix = suffix.toLowerCase(Locale.ROOT);
        this.world = world;
        this.dimensions = dimensions;
    }

    public int getUnifiedColor() {
        return -16777216 + ((int)(this.red * 255.0f) << 16) + ((int)(this.green * 255.0f) << 8) + (int)(this.blue * 255.0f);
    }

    public boolean isActive() {
        return this.enabled && this.inWorld && this.inDimension;
    }

    public int getX() {
        return (int)((double)this.x / VoxelConstants.getPlayer().method_37908().method_8597().comp_646());
    }

    public int getZ() {
        return (int)((double)this.z / VoxelConstants.getPlayer().method_37908().method_8597().comp_646());
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = (int)((double)x * VoxelConstants.getPlayer().method_37908().method_8597().comp_646());
    }

    public void setZ(int z) {
        this.z = (int)((double)z * VoxelConstants.getPlayer().method_37908().method_8597().comp_646());
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int compareTo(Waypoint o) {
        double myDistance = this.getDistanceSqToEntity((class_1297)VoxelConstants.getPlayer());
        double comparedDistance = o.getDistanceSqToEntity((class_1297)VoxelConstants.getPlayer());
        return Double.compare(myDistance, comparedDistance);
    }

    public double getDistanceSqToEntity(class_1297 par1Entity) {
        double var2 = (double)this.getX() + 0.5 - par1Entity.method_23317();
        double var4 = (double)this.getY() + 0.5 - par1Entity.method_23318();
        double var6 = (double)this.getZ() + 0.5 - par1Entity.method_23321();
        return var2 * var2 + var4 * var4 + var6 * var6;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Waypoint)) {
            return false;
        }
        Waypoint otherWaypoint = (Waypoint)obj;
        return this.name.equals(otherWaypoint.name) && this.imageSuffix.equals(otherWaypoint.imageSuffix) && this.world.equals(otherWaypoint.world) && this.x == otherWaypoint.x && this.y == otherWaypoint.y && this.z == otherWaypoint.z && this.red == otherWaypoint.red && this.green == otherWaypoint.green && this.blue == otherWaypoint.blue && this.dimensions.equals(otherWaypoint.dimensions);
    }
}

