/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.OpenGL;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2818;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_327;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Quaternionfc;

public class WaypointContainer {
    private final List<Waypoint> wayPts = new ArrayList<Waypoint>();
    private Waypoint highlightedWaypoint;
    public final MapSettingsManager options;

    public WaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.wayPts.remove(waypoint);
    }

    public void setHighlightedWaypoint(Waypoint highlightedWaypoint) {
        this.highlightedWaypoint = highlightedWaypoint;
    }

    private void sortWaypoints() {
        this.wayPts.sort(Collections.reverseOrder());
    }

    public void renderWaypoints(float partialTicks, Matrix4fStack matrixStack, boolean beacons, boolean signs, boolean withDepth, boolean withoutDepth) {
        int z;
        int x;
        this.sortWaypoints();
        class_1297 cameraEntity = VoxelConstants.getMinecraft().method_1560();
        double renderPosX = GameVariableAccessShim.xCoordDouble();
        double renderPosY = GameVariableAccessShim.yCoordDouble();
        double renderPosZ = GameVariableAccessShim.zCoordDouble();
        OpenGL.glEnable(2884);
        if (this.options.showBeacons && beacons) {
            OpenGL.glEnable(2929);
            OpenGL.glDepthMask(false);
            OpenGL.glEnable(3042);
            OpenGL.glBlendFunc(770, 1);
            RenderSystem.setShader(class_757::method_34540);
            for (Waypoint pt : this.wayPts) {
                if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
                x = pt.getX();
                z = pt.getZ();
                class_2818 chunk = VoxelConstants.getPlayer().method_37908().method_8497(x >> 4, z >> 4);
                if (chunk == null || chunk.method_12223() || !VoxelConstants.getPlayer().method_37908().method_8393(x >> 4, z >> 4)) continue;
                double bottomOfWorld = (double)VoxelConstants.getPlayer().method_37908().method_31607() - renderPosY;
                this.renderBeam(pt, (double)x - renderPosX, bottomOfWorld, (double)z - renderPosZ, (Matrix4f)matrixStack);
            }
            OpenGL.glDisable(3042);
            OpenGL.glDepthMask(true);
        }
        if (this.options.showWaypoints && signs) {
            OpenGL.glEnable(3042);
            OpenGL.glBlendFuncSeparate(770, 771, 1, 771);
            for (Waypoint pt : this.wayPts) {
                if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
                x = pt.getX();
                z = pt.getZ();
                int y = pt.getY();
                double distance = Math.sqrt(pt.getDistanceSqToEntity(cameraEntity));
                if (!(distance < (double)this.options.maxWaypointDisplayDistance) && this.options.maxWaypointDisplayDistance >= 0 && pt != this.highlightedWaypoint || VoxelConstants.getMinecraft().field_1690.field_1842) continue;
                boolean isPointedAt = this.isPointedAt(pt, distance, cameraEntity, Float.valueOf(partialTicks));
                String label = pt.name;
                this.renderLabel(matrixStack, pt, distance, isPointedAt, label, false, (double)x - renderPosX, (double)y - renderPosY - 0.5, (double)z - renderPosZ, withDepth, withoutDepth);
            }
            if (this.highlightedWaypoint != null && !VoxelConstants.getMinecraft().field_1690.field_1842) {
                int x2 = this.highlightedWaypoint.getX();
                int z2 = this.highlightedWaypoint.getZ();
                int y = this.highlightedWaypoint.getY();
                double distance = Math.sqrt(this.highlightedWaypoint.getDistanceSqToEntity(cameraEntity));
                boolean isPointedAt = this.isPointedAt(this.highlightedWaypoint, distance, cameraEntity, Float.valueOf(partialTicks));
                this.renderLabel(matrixStack, this.highlightedWaypoint, distance, isPointedAt, "", true, (double)x2 - renderPosX, (double)y - renderPosY - 0.5, (double)z2 - renderPosZ, withDepth, withoutDepth);
            }
            OpenGL.glEnable(2929);
            OpenGL.glDepthMask(true);
            OpenGL.glDisable(3042);
        }
    }

    private boolean isPointedAt(Waypoint waypoint, double distance, class_1297 cameraEntity, Float partialTicks) {
        class_243 cameraPos = cameraEntity.method_5836(partialTicks.floatValue());
        double degrees = 5.0 + Math.min(5.0 / distance, 5.0);
        double angle = degrees * 0.0174533;
        double size = Math.sin(angle) * distance;
        class_243 cameraPosPlusDirection = cameraEntity.method_5828(partialTicks.floatValue());
        class_243 cameraPosPlusDirectionTimesDistance = cameraPos.method_1031(cameraPosPlusDirection.field_1352 * distance, cameraPosPlusDirection.field_1351 * distance, cameraPosPlusDirection.field_1350 * distance);
        class_238 axisalignedbb = new class_238((double)((float)waypoint.getX() + 0.5f) - size, (double)((float)waypoint.getY() + 1.5f) - size, (double)((float)waypoint.getZ() + 0.5f) - size, (double)((float)waypoint.getX() + 0.5f) + size, (double)((float)waypoint.getY() + 1.5f) + size, (double)((float)waypoint.getZ() + 0.5f) + size);
        Optional raytraceresult = axisalignedbb.method_992(cameraPos, cameraPosPlusDirectionTimesDistance);
        if (axisalignedbb.method_1006(cameraPos)) {
            return distance >= 1.0;
        }
        return raytraceresult.isPresent();
    }

    private void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, Matrix4f matrix4f) {
        class_289 tessellator = class_289.method_1348();
        int height = VoxelConstants.getClientWorld().method_31605();
        float brightness = 0.06f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        for (int width = 0; width < 4; ++width) {
            class_287 vertexBuffer = tessellator.method_60827(class_293.class_5596.field_27380, class_290.field_1576);
            double d6 = 0.1 + (double)width * 0.2;
            d6 *= topWidthFactor;
            double d7 = 0.1 + (double)width * 0.2;
            d7 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                float vertX2 = (float)(baseX + 0.5 - d6);
                float vertZ2 = (float)(baseZ + 0.5 - d6);
                if (side == 1 || side == 2) {
                    vertX2 = (float)((double)vertX2 + d6 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ2 = (float)((double)vertZ2 + d6 * 2.0);
                }
                float vertX1 = (float)(baseX + 0.5 - d7);
                float vertZ1 = (float)(baseZ + 0.5 - d7);
                if (side == 1 || side == 2) {
                    vertX1 = (float)((double)vertX1 + d7 * 2.0);
                }
                if (side == 2 || side == 3) {
                    vertZ1 = (float)((double)vertZ1 + d7 * 2.0);
                }
                vertexBuffer.method_22918(matrix4f, vertX1, (float)baseY + 0.0f, vertZ1).method_22915(r * brightness, g * brightness, b * brightness, 0.8f);
                vertexBuffer.method_22918(matrix4f, vertX2, (float)baseY + (float)height, vertZ2).method_22915(r * brightness, g * brightness, b * brightness, 0.8f);
            }
            class_286.method_43433((class_9801)vertexBuffer.method_60800());
        }
    }

    private void renderLabel(Matrix4fStack matrixStack, Waypoint pt, double distance, boolean isPointedAt, String name, boolean target, double baseX, double baseY, double baseZ, boolean withDepth, boolean withoutDepth) {
        class_287 vertexBuffer;
        Sprite icon;
        if (target) {
            if (pt.red == 2.0f && pt.green == 0.0f && pt.blue == 0.0f) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            } else {
                isPointedAt = false;
            }
        }
        name = (String)name + " (" + (int)distance + "m)";
        double maxDistance = (double)((Integer)VoxelConstants.getMinecraft().field_1690.method_42510().method_41753()).intValue() * 16.0 * 0.99;
        double adjustedDistance = distance;
        if (distance > maxDistance) {
            baseX = baseX / distance * maxDistance;
            baseY = baseY / distance * maxDistance;
            baseZ = baseZ / distance * maxDistance;
            adjustedDistance = maxDistance;
        }
        float var14 = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f;
        matrixStack.pushMatrix();
        matrixStack.translate((float)baseX + 0.5f, (float)baseY + 0.5f, (float)baseZ + 0.5f);
        matrixStack.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-VoxelConstants.getMinecraft().method_1561().field_4686.method_19330()));
        matrixStack.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(VoxelConstants.getMinecraft().method_1561().field_4686.method_19329()));
        matrixStack.scale(-var14, -var14, -var14);
        class_289 tessellator = class_289.method_1348();
        float fade = distance > 5.0 ? 1.0f : (float)distance / 5.0f;
        fade = Math.min(fade, !pt.enabled && !target ? 0.3f : 1.0f);
        float width = 10.0f;
        float r = target ? 1.0f : pt.red;
        float g = target ? 0.0f : pt.green;
        float b = target ? 0.0f : pt.blue;
        TextureAtlas textureAtlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
        Sprite sprite = icon = target ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
        if (icon == textureAtlas.getMissingImage()) {
            icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
        }
        RenderSystem.setShader(class_757::method_34543);
        OpenGL.Utils.disp2(textureAtlas.method_4624());
        if (withDepth) {
            OpenGL.glDepthMask(distance < maxDistance);
            OpenGL.glEnable(2929);
            vertexBuffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            vertexBuffer.method_22918((Matrix4f)matrixStack, -width, -width, 0.0f).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, fade);
            vertexBuffer.method_22918((Matrix4f)matrixStack, -width, width, 0.0f).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, fade);
            vertexBuffer.method_22918((Matrix4f)matrixStack, width, width, 0.0f).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, fade);
            vertexBuffer.method_22918((Matrix4f)matrixStack, width, -width, 0.0f).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, fade);
            class_286.method_43433((class_9801)vertexBuffer.method_60800());
        }
        if (withoutDepth) {
            OpenGL.glDisable(2929);
            OpenGL.glDepthMask(false);
            vertexBuffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            vertexBuffer.method_22918((Matrix4f)matrixStack, -width, -width, 0.0f).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, 0.3f * fade);
            vertexBuffer.method_22918((Matrix4f)matrixStack, -width, width, 0.0f).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, 0.3f * fade);
            vertexBuffer.method_22918((Matrix4f)matrixStack, width, width, 0.0f).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, 0.3f * fade);
            vertexBuffer.method_22918((Matrix4f)matrixStack, width, -width, 0.0f).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, 0.3f * fade);
            class_286.method_43433((class_9801)vertexBuffer.method_60800());
        }
        class_327 fontRenderer = VoxelConstants.getMinecraft().field_1772;
        if (isPointedAt && fontRenderer != null) {
            class_287 vertexBuffer2;
            int elevateBy = -19;
            OpenGL.glEnable(32823);
            int halfStringWidth = fontRenderer.method_1727((String)name) / 2;
            RenderSystem.setShader(class_757::method_34540);
            if (withDepth) {
                OpenGL.glEnable(2929);
                OpenGL.glDepthMask(distance < maxDistance);
                OpenGL.glPolygonOffset(1.0f, 7.0f);
                vertexBuffer2 = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade);
                class_286.method_43433((class_9801)vertexBuffer2.method_60800());
                OpenGL.glPolygonOffset(1.0f, 5.0f);
                vertexBuffer2 = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                class_286.method_43433((class_9801)vertexBuffer2.method_60800());
            }
            if (withoutDepth) {
                OpenGL.glDisable(2929);
                OpenGL.glDepthMask(false);
                OpenGL.glPolygonOffset(1.0f, 11.0f);
                vertexBuffer2 = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 2), (float)(9 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 2), (float)(-2 + elevateBy), 0.0f).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade);
                class_286.method_43433((class_9801)vertexBuffer2.method_60800());
                OpenGL.glPolygonOffset(1.0f, 9.0f);
                vertexBuffer2 = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(-halfStringWidth - 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 1), (float)(8 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                vertexBuffer2.method_22918((Matrix4f)matrixStack, (float)(halfStringWidth + 1), (float)(-1 + elevateBy), 0.0f).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade);
                class_286.method_43433((class_9801)vertexBuffer2.method_60800());
            }
            OpenGL.glDisable(32823);
            OpenGL.glDepthMask(false);
            class_4597.class_4598 vertexConsumerProvider = VoxelConstants.getMinecraft().method_22940().method_23000();
            if (withoutDepth) {
                int textColor = (int)(255.0f * fade) << 24 | 0xCCCCCC;
                OpenGL.glDisable(2929);
                fontRenderer.method_30882((class_2561)class_2561.method_43470((String)name), (float)(-fontRenderer.method_1727((String)name)) / 2.0f, (float)elevateBy, textColor, false, (Matrix4f)matrixStack, (class_4597)vertexConsumerProvider, class_327.class_6415.field_33994, 0, 0xF000F0);
                vertexConsumerProvider.method_22993();
            }
            OpenGL.glEnable(3042);
        }
        OpenGL.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.popMatrix();
    }
}

