/*
 * Decompiled with CFR 0.152.
 */
package elias.zoom.client;

import com.mojang.brigadier.Message;
import elias.zoom.client.ModMenuIntegration;
import elias.zoom.client.config.ZoomModConfig;
import java.util.Objects;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_442;
import net.minecraft.class_5250;

public class ZoomModClient
implements ClientModInitializer {
    private static boolean CHECKED_KEYBINDING = false;
    private static boolean currentlyZoomed;
    private static class_304 zoomKeyBinding;
    private static boolean originalSmoothCameraEnabled;
    private static final class_310 mc;
    private static double targetZoomLevel;
    private static double zoomLevel;
    private static boolean keyPressedLastFrame;

    public void onInitializeClient() {
        ZoomModConfig.loadConfig();
        zoomKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.zoom", class_3675.class_307.field_1668, 67, "category.zoom"));
        currentlyZoomed = false;
        originalSmoothCameraEnabled = false;
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (!CHECKED_KEYBINDING && screen instanceof class_442) {
                this.checkKeyBinding(zoomKeyBinding);
                CHECKED_KEYBINDING = true;
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                ZoomModClient.updateZoom();
                ZoomModClient.manageSmoothCamera();
            }
        });
        if (FabricLoader.getInstance().isModLoaded("modmenu")) {
            new ModMenuIntegration();
        }
    }

    private void checkKeyBinding(class_304 keyBinding) {
        int count = 0;
        for (class_304 otherKeyBinding : ZoomModClient.mc.field_1690.field_1839) {
            if (Objects.equals(otherKeyBinding.method_1428(), keyBinding.method_1428())) {
                ++count;
            }
            if (count <= 1) continue;
            class_5250 title = class_2561.method_43471((String)"keybind.title.zoom");
            class_5250 desc = class_2561.method_43471((String)"keybind.desc.zoom");
            ZoomModClient.displayToast(title, desc);
        }
    }

    public static void displayToast(class_5250 title, class_5250 description) {
        class_370 toast = new class_370(class_370.class_9037.field_49487, class_2561.method_54155((Message)title), class_2561.method_54155((Message)description));
        class_374 toastManager = mc.method_1566();
        toastManager.method_1999((class_368)toast);
    }

    public static boolean isZooming() {
        return zoomKeyBinding.method_1434();
    }

    public static double getZoomLevel() {
        return zoomLevel;
    }

    public static void zoomIn() {
        if (zoomLevel < ZoomModConfig.maxZoom) {
            targetZoomLevel = Math.min(targetZoomLevel + ZoomModConfig.instantZoomIncrement, ZoomModConfig.maxZoom);
        }
    }

    public static void zoomOut() {
        if (zoomLevel > ZoomModConfig.minZoom) {
            targetZoomLevel = Math.max(targetZoomLevel - ZoomModConfig.instantZoomIncrement, ZoomModConfig.minZoom);
        }
    }

    private static void updateZoom() {
        boolean isPressed = ZoomModClient.isZooming();
        if (isPressed && !keyPressedLastFrame) {
            targetZoomLevel = Math.min(targetZoomLevel + ZoomModConfig.zoomIncrement, ZoomModConfig.maxZoom);
            if (ZoomModConfig.enableZoomSound) {
                ZoomModClient.playZoomSound();
            }
        } else if (!isPressed && keyPressedLastFrame) {
            targetZoomLevel = ZoomModConfig.defaultZoomLevel;
        }
        double zoomStep = ZoomModConfig.zoomSmoothing * ZoomModConfig.zoomSpeed;
        if (zoomLevel < targetZoomLevel) {
            zoomLevel = Math.min(zoomLevel + zoomStep, targetZoomLevel);
        } else if (zoomLevel > targetZoomLevel) {
            zoomLevel = Math.max(zoomLevel - zoomStep, targetZoomLevel);
        }
        keyPressedLastFrame = isPressed;
    }

    private static void playZoomSound() {
        if (ZoomModClient.mc.field_1724 != null && ZoomModClient.mc.field_1687 != null) {
            ZoomModClient.mc.field_1687.method_8486(ZoomModClient.mc.field_1724.method_23317(), ZoomModClient.mc.field_1724.method_23318(), ZoomModClient.mc.field_1724.method_23321(), class_3417.field_14641, class_3419.field_15248, 0.5f, 1.0f, false);
        }
    }

    public static void manageSmoothCamera() {
        if (ZoomModClient.zoomStarting()) {
            ZoomModClient.zoomStarted();
            ZoomModClient.enableSmoothCamera();
        }
        if (ZoomModClient.zoomStopping()) {
            ZoomModClient.zoomStopped();
            ZoomModClient.resetSmoothCamera();
        }
    }

    private static boolean isSmoothCamera() {
        return ZoomModClient.mc.field_1690.field_1914;
    }

    private static void enableSmoothCamera() {
        ZoomModClient.mc.field_1690.field_1914 = true;
    }

    private static void disableSmoothCamera() {
        ZoomModClient.mc.field_1690.field_1914 = false;
    }

    private static boolean zoomStarting() {
        return ZoomModClient.isZooming() && !currentlyZoomed;
    }

    private static boolean zoomStopping() {
        return !ZoomModClient.isZooming() && currentlyZoomed;
    }

    private static void zoomStarted() {
        originalSmoothCameraEnabled = ZoomModClient.isSmoothCamera();
        currentlyZoomed = true;
    }

    private static void zoomStopped() {
        currentlyZoomed = false;
    }

    private static void resetSmoothCamera() {
        if (originalSmoothCameraEnabled) {
            ZoomModClient.enableSmoothCamera();
        } else {
            ZoomModClient.disableSmoothCamera();
        }
    }

    static {
        mc = class_310.method_1551();
        keyPressedLastFrame = false;
    }
}

