/*
 * Decompiled with CFR 0.152.
 */
package elias.zoom.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.DoubleFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ZoomModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final File CONFIG_DIR = new File(ZoomModConfig.CLIENT.field_1697, "config");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "zoom_mod_config.json");
    private static final File DEFAULT_CONFIG_FILE = new File(CONFIG_DIR, "default_zoom_mod_config.json");
    public static double zoomIncrement = 0.05;
    public static double maxZoom = 0.83;
    public static double minZoom = 0.03;
    public static double zoomSmoothing = 0.05;
    public static double instantZoomIncrement = 0.1;
    public static double defaultZoomLevel = 0.23;
    public static double zoomSpeed = 0.5;
    public static boolean enableZoomSound = false;

    public static void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            ZoomModConfig.saveConfig();
        } else {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                zoomIncrement = jsonObject.get("zoomIncrement").getAsDouble();
                maxZoom = jsonObject.get("maxZoom").getAsDouble();
                minZoom = jsonObject.get("minZoom").getAsDouble();
                zoomSmoothing = jsonObject.get("zoomSmoothing").getAsDouble();
                instantZoomIncrement = jsonObject.get("instantZoomIncrement").getAsDouble();
                defaultZoomLevel = jsonObject.get("defaultZoomLevel").getAsDouble();
                zoomSpeed = jsonObject.get("zoomSpeed").getAsDouble();
                enableZoomSound = jsonObject.get("enableZoomSound").getAsBoolean();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("zoomIncrement", (Number)zoomIncrement);
        jsonObject.addProperty("maxZoom", (Number)maxZoom);
        jsonObject.addProperty("minZoom", (Number)minZoom);
        jsonObject.addProperty("zoomSmoothing", (Number)zoomSmoothing);
        jsonObject.addProperty("instantZoomIncrement", (Number)instantZoomIncrement);
        jsonObject.addProperty("defaultZoomLevel", (Number)defaultZoomLevel);
        jsonObject.addProperty("zoomSpeed", (Number)zoomSpeed);
        jsonObject.addProperty("enableZoomSound", Boolean.valueOf(enableZoomSound));
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void resetToDefaults() {
        if (DEFAULT_CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(DEFAULT_CONFIG_FILE);){
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                zoomIncrement = jsonObject.get("zoomIncrement").getAsDouble();
                maxZoom = jsonObject.get("maxZoom").getAsDouble();
                minZoom = jsonObject.get("minZoom").getAsDouble();
                zoomSmoothing = jsonObject.get("zoomSmoothing").getAsDouble();
                instantZoomIncrement = jsonObject.get("instantZoomIncrement").getAsDouble();
                defaultZoomLevel = jsonObject.get("defaultZoomLevel").getAsDouble();
                zoomSpeed = jsonObject.get("zoomSpeed").getAsDouble();
                enableZoomSound = jsonObject.get("enableZoomSound").getAsBoolean();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            zoomIncrement = 0.05;
            maxZoom = 0.83;
            minZoom = 0.03;
            zoomSmoothing = 0.05;
            instantZoomIncrement = 0.1;
            defaultZoomLevel = 0.23;
            zoomSpeed = 0.5;
            enableZoomSound = false;
        }
        ZoomModConfig.saveConfig();
    }

    public static class_437 getConfigScreen(class_437 parent) {
        return YetAnotherConfigLib.createBuilder().title(class_2561.method_30163((String)"Zoom Mod Configuration")).category(ConfigCategory.createBuilder().name(class_2561.method_30163((String)"Zoom Options")).tooltip(new class_2561[]{class_2561.method_30163((String)"Configure your zoom settings here.")}).group(OptionGroup.createBuilder().description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Adjust your zoom preferences.")})).option(Option.createBuilder().name(class_2561.method_30163((String)"Zoom Increment")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Controls the zoom level increase or decrease with each zoom action. \n\nDefault value: 0.05")})).binding((Object)zoomIncrement, () -> zoomIncrement, newVal -> {
            zoomIncrement = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Max Zoom")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The maximum zoom level achievable. \n\nDefault value: 0.83")})).binding((Object)maxZoom, () -> maxZoom, newVal -> {
            maxZoom = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Min Zoom")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The minimum zoom level achievable. \n\nDefault value: 0.03")})).binding((Object)minZoom, () -> minZoom, newVal -> {
            minZoom = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Zoom Smoothing")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Smoothing applied to the zoom transition; higher values mean smoother zooming. \n\nDefault value: 0.05")})).binding((Object)zoomSmoothing, () -> zoomSmoothing, newVal -> {
            zoomSmoothing = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Instant Zoom Increment")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The zoom increment applied instantly when zooming in or out. \n\nDefault value: 0.1")})).binding((Object)instantZoomIncrement, () -> instantZoomIncrement, newVal -> {
            instantZoomIncrement = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Default Zoom Level")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The default zoom level when the zoom key is pressed. \n\nDefault value: 0.23")})).binding((Object)defaultZoomLevel, () -> defaultZoomLevel, newVal -> {
            defaultZoomLevel = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Zoom Speed")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"The speed at which zooming occurs. \n\nDefault value: 0.5")})).binding((Object)zoomSpeed, () -> zoomSpeed, newVal -> {
            zoomSpeed = newVal;
        }).controller(DoubleFieldControllerBuilder::create).build()).option(Option.createBuilder().name(class_2561.method_30163((String)"Enable Zoom Sound")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_30163((String)"Toggle the zoom sound effect. Set to true to enable, false to disable. \n\nDefault value: false")})).binding((Object)enableZoomSound, () -> enableZoomSound, newVal -> {
            enableZoomSound = newVal;
        }).controller(TickBoxControllerBuilder::create).build()).build()).build()).build().generateScreen(parent);
    }
}

