/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMaps;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import it.unimi.dsi.fastutil.objects.ReferenceSets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferArena;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateTypes;
import net.caffeinemc.mods.sodium.client.render.chunk.DefaultChunkRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.DeferMode;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionFlags;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.BuilderTaskOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkSortOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.JobDurationEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.JobEffort;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.LimitedResourceBudget;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshResultSize;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.MeshTaskSizeEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.UnlimitedResourceBudget;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.UploadDuration;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.UploadDurationEstimator;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.UploadResourceBudget;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobResult;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.executor.ChunkJobTyped;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderMeshingTask;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderSortingTask;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.ChunkRenderList;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.OcclusionSectionCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SectionCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SortedRenderLists;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.TreeSectionCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.GraphDirection;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.DynamicTopoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.NoData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.CameraMovement;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.trigger.SortTriggering;
import net.caffeinemc.mods.sodium.client.render.chunk.tree.RemovableMultiForest;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import net.caffeinemc.mods.sodium.client.render.util.RenderAsserts;
import net.caffeinemc.mods.sodium.client.render.viewport.CameraTransform;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.iterator.ByteIterator;
import net.caffeinemc.mods.sodium.client.util.task.CancellationToken;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.caffeinemc.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.class_1058;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;

public class RenderSectionManager {
    private static final float NEARBY_REBUILD_DISTANCE = class_3532.method_27285((float)16.0f);
    private static final float NEARBY_SORT_DISTANCE = class_3532.method_27285((float)25.0f);
    private static final float FRAME_DURATION_UPLOAD_FRACTION = 0.1f;
    private static final long MIN_UPLOAD_DURATION_BUDGET = 2000000L;
    private final ChunkBuilder builder;
    private final RenderRegionManager regions;
    private final ClonedChunkSectionCache sectionCache;
    private final Long2ReferenceMap<RenderSection> sectionByPosition = new Long2ReferenceOpenHashMap();
    private final ConcurrentLinkedDeque<ChunkJobResult<? extends BuilderTaskOutput>> buildResults = new ConcurrentLinkedDeque();
    private final JobDurationEstimator jobDurationEstimator = new JobDurationEstimator();
    private final MeshTaskSizeEstimator meshTaskSizeEstimator;
    private final UploadDurationEstimator jobUploadDurationEstimator = new UploadDurationEstimator();
    private ChunkJobCollector lastBlockingCollector;
    private int thisFrameBlockingTasks;
    private int nextFrameBlockingTasks;
    private int deferredTasks;
    private final ChunkRenderer chunkRenderer;
    private final class_638 level;
    private final ReferenceSet<RenderSection> sectionsWithGlobalEntities = new ReferenceOpenHashSet();
    private final OcclusionCuller occlusionCuller;
    private final int renderDistance;
    private final SortBehavior sortBehavior;
    private final SortTriggering sortTriggering;
    @NotNull
    private SortedRenderLists renderLists;
    @NotNull
    private Map<TaskQueueType, ArrayDeque<RenderSection>> taskLists;
    private int frame;
    private long lastFrameDuration = -1L;
    private long averageFrameDuration = -1L;
    private long lastFrameAtTime = System.nanoTime();
    private static final float FRAME_DURATION_UPDATE_RATIO = 0.05f;
    private boolean needsGraphUpdate = true;
    private int lastUpdatedFrame;
    @Nullable
    private Vector3dc cameraPosition;
    private final RemovableMultiForest renderableSectionTree;

    public RenderSectionManager(class_638 level, int renderDistance, SortBehavior sortBehavior, CommandList commandList) {
        this.meshTaskSizeEstimator = new MeshTaskSizeEstimator(level);
        this.chunkRenderer = new DefaultChunkRenderer(RenderDevice.INSTANCE, ChunkMeshFormats.COMPACT);
        this.level = level;
        this.builder = new ChunkBuilder(level, ChunkMeshFormats.COMPACT);
        this.renderDistance = renderDistance;
        this.sortBehavior = sortBehavior;
        this.sortTriggering = this.sortBehavior != SortBehavior.OFF ? new SortTriggering() : null;
        this.regions = new RenderRegionManager(commandList);
        this.sectionCache = new ClonedChunkSectionCache((class_1937)this.level);
        this.renderLists = SortedRenderLists.empty();
        this.occlusionCuller = new OcclusionCuller((Long2ReferenceMap<RenderSection>)Long2ReferenceMaps.unmodifiable(this.sectionByPosition), (class_1937)this.level);
        this.renderableSectionTree = new RemovableMultiForest(renderDistance);
        this.taskLists = new EnumMap<TaskQueueType, ArrayDeque<RenderSection>>(TaskQueueType.class);
        for (TaskQueueType type : TaskQueueType.values()) {
            this.taskLists.put(type, new ArrayDeque());
        }
    }

    public void prepareFrame(Vector3dc cameraPosition) {
        long now = System.nanoTime();
        this.lastFrameDuration = now - this.lastFrameAtTime;
        this.lastFrameAtTime = now;
        this.averageFrameDuration = this.averageFrameDuration == -1L ? this.lastFrameDuration : MathUtil.exponentialMovingAverage(this.averageFrameDuration, this.lastFrameDuration, 0.05f);
        this.averageFrameDuration = class_3532.method_53062((long)this.averageFrameDuration, (long)1000100L, (long)100000000L);
        ++this.frame;
        this.cameraPosition = cameraPosition;
    }

    public void update(class_4184 camera, Viewport viewport, FogParameters fogParameters, boolean spectator) {
        ++this.lastUpdatedFrame;
        this.needsGraphUpdate = this.createTerrainRenderList(camera, viewport, fogParameters, this.lastUpdatedFrame, spectator);
    }

    private boolean createTerrainRenderList(class_4184 camera, Viewport viewport, FogParameters fogParameters, int frame, boolean spectator) {
        SectionCollector renderListProvider;
        this.resetRenderLists();
        float searchDistance = this.getSearchDistance(fogParameters);
        boolean useOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        TaskQueueType importantRebuildQueueType = SodiumClientMod.options().performance.chunkBuildDeferMode.getImportantRebuildQueueType();
        if (this.isOutOfGraph(viewport.getChunkCoord())) {
            TreeSectionCollector visitor = new TreeSectionCollector(frame, importantRebuildQueueType, this.sectionByPosition);
            this.renderableSectionTree.prepareForTraversal();
            this.renderableSectionTree.traverse(visitor, viewport, searchDistance);
            renderListProvider = visitor;
        } else {
            OcclusionSectionCollector visitor = new OcclusionSectionCollector(frame, importantRebuildQueueType);
            this.occlusionCuller.findVisible(visitor, viewport, searchDistance, useOcclusionCulling, frame);
            renderListProvider = visitor;
        }
        this.renderLists = renderListProvider.createRenderLists(viewport);
        this.taskLists = renderListProvider.getTaskLists();
        return renderListProvider.needsRevisitForPendingUpdates();
    }

    private boolean isOutOfGraph(class_4076 pos) {
        int sectionY = pos.method_10264();
        return this.level.method_32891() <= sectionY && sectionY <= this.level.method_31597() && !this.sectionByPosition.containsKey(pos.method_18694());
    }

    private float getSearchDistance(FogParameters fogParameters) {
        float distance = SodiumClientMod.options().performance.useFogOcclusion ? this.getEffectiveRenderDistance(fogParameters) : this.getRenderDistance();
        return distance;
    }

    private boolean shouldUseOcclusionCulling(class_4184 camera, boolean spectator) {
        class_2338 origin = camera.method_19328();
        boolean useOcclusionCulling = spectator && this.level.method_8320(origin).method_26216() ? false : class_310.method_1551().field_1730;
        return useOcclusionCulling;
    }

    public void beforeSectionUpdates() {
        this.renderableSectionTree.ensureCapacity(this.getRenderDistance());
    }

    private void resetRenderLists() {
        this.renderLists = SortedRenderLists.empty();
        for (ArrayDeque<RenderSection> list : this.taskLists.values()) {
            list.clear();
        }
    }

    public void onSectionAdded(int x, int y, int z) {
        long key = class_4076.method_18685((int)x, (int)y, (int)z);
        if (this.sectionByPosition.containsKey(key)) {
            return;
        }
        RenderRegion region = this.regions.createForChunk(x, y, z);
        RenderSection renderSection = new RenderSection(region, x, y, z);
        region.addSection(renderSection);
        this.sectionByPosition.put(key, (Object)renderSection);
        class_2818 chunk = this.level.method_8497(x, z);
        class_2826 section = chunk.method_12006()[this.level.method_31603(y)];
        if (section.method_38292()) {
            this.updateSectionInfo(renderSection, BuiltSectionInfo.EMPTY);
        } else {
            this.renderableSectionTree.add(renderSection);
            renderSection.setPendingUpdate(8, this.lastFrameAtTime);
        }
        this.connectNeighborNodes(renderSection);
        this.markGraphDirty();
    }

    public void onSectionRemoved(int x, int y, int z) {
        RenderRegion region;
        long sectionPos = class_4076.method_18685((int)x, (int)y, (int)z);
        RenderSection section = (RenderSection)this.sectionByPosition.remove(sectionPos);
        if (section == null) {
            return;
        }
        this.renderableSectionTree.remove(x, y, z);
        if (section.getTranslucentData() != null) {
            this.sortTriggering.removeSection(section.getTranslucentData(), sectionPos);
        }
        if ((region = section.getRegion()) != null) {
            region.removeSection(section);
        }
        this.disconnectNeighborNodes(section);
        this.updateSectionInfo(section, null);
        section.delete();
        this.markGraphDirty();
    }

    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z, FogParameters fogParameters) {
        RenderDevice device = RenderDevice.INSTANCE;
        CommandList commandList = device.createCommandList();
        this.chunkRenderer.render(matrices, commandList, this.renderLists, pass, new CameraTransform(x, y, z), fogParameters, this.sortBehavior != SortBehavior.OFF);
        commandList.flush();
    }

    public void tickVisibleRenders() {
        Iterator<ChunkRenderList> it = this.renderLists.iterator();
        while (it.hasNext()) {
            ChunkRenderList renderList = it.next();
            RenderRegion region = renderList.getRegion();
            ByteIterator iterator = renderList.sectionsWithSpritesIterator();
            if (iterator == null) continue;
            while (iterator.hasNext()) {
                class_1058[] sprites;
                RenderSection section = region.getSection(iterator.nextByteAsInt());
                if (section == null || (sprites = section.getAnimatedSprites()) == null) continue;
                for (class_1058 sprite : sprites) {
                    SpriteUtil.INSTANCE.markSpriteActive(sprite);
                }
            }
        }
    }

    public boolean isSectionVisible(int x, int y, int z) {
        RenderSection render = this.getRenderSection(x, y, z);
        if (render == null) {
            return false;
        }
        return render.getLastVisibleFrame() == this.lastUpdatedFrame;
    }

    public void uploadChunks() {
        ArrayList<BuilderTaskOutput> results = this.collectChunkBuildResults();
        if (results.isEmpty()) {
            return;
        }
        this.needsGraphUpdate |= this.processChunkBuildResults(results);
        for (BuilderTaskOutput result : results) {
            result.destroy();
        }
    }

    private boolean processChunkBuildResults(ArrayList<BuilderTaskOutput> results) {
        List<BuilderTaskOutput> filtered = RenderSectionManager.filterChunkBuildResults(results);
        long start = System.nanoTime();
        this.regions.uploadResults(RenderDevice.INSTANCE.createCommandList(), filtered);
        long uploadDuration = System.nanoTime() - start;
        boolean touchedSectionInfo = false;
        long totalUploadSize = 0L;
        for (BuilderTaskOutput result : filtered) {
            CancellationToken job;
            TranslucentData translucentData;
            ChunkSortOutput sortOutput;
            long resultSize = result.getResultSize();
            TranslucentData oldData = result.render.getTranslucentData();
            if (result instanceof ChunkBuildOutput) {
                ChunkBuildOutput chunkBuildOutput = (ChunkBuildOutput)result;
                touchedSectionInfo |= this.updateSectionInfo(result.render, chunkBuildOutput.info);
                result.render.setLastMeshResultSize(resultSize);
                this.meshTaskSizeEstimator.addData(this.meshTaskSizeEstimator.resultForSection(result.render, resultSize));
                if (chunkBuildOutput.translucentData != null) {
                    this.sortTriggering.integrateTranslucentData(oldData, chunkBuildOutput.translucentData, this.cameraPosition, this::scheduleSort);
                    result.render.setTranslucentData(chunkBuildOutput.translucentData);
                }
            } else if (result instanceof ChunkSortOutput && (sortOutput = (ChunkSortOutput)result).getDynamicSorter() != null && (translucentData = result.render.getTranslucentData()) instanceof DynamicTopoData) {
                DynamicTopoData data = (DynamicTopoData)translucentData;
                this.sortTriggering.applyTriggerChanges(data, sortOutput.getDynamicSorter(), result.render.getPosition(), this.cameraPosition);
            }
            if ((job = result.render.getTaskCancellationToken()) != null && result.submitTime >= result.render.getLastSubmittedFrame()) {
                result.render.setTaskCancellationToken(null);
            }
            result.render.setLastUploadFrame(result.submitTime);
            totalUploadSize += resultSize;
        }
        this.meshTaskSizeEstimator.updateModels();
        if (!filtered.isEmpty()) {
            this.jobUploadDurationEstimator.addData(new UploadDuration(uploadDuration / (long)filtered.size(), totalUploadSize / (long)filtered.size()));
            this.jobUploadDurationEstimator.updateModels();
        }
        return touchedSectionInfo;
    }

    private boolean updateSectionInfo(RenderSection render, BuiltSectionInfo info) {
        if (info == null || !RenderSectionFlags.needsRender(info.flags)) {
            this.renderableSectionTree.remove(render);
        } else {
            this.renderableSectionTree.add(render);
        }
        boolean infoChanged = render.setInfo(info);
        if (info == null || ArrayUtils.isEmpty((Object[])info.globalBlockEntities)) {
            return this.sectionsWithGlobalEntities.remove((Object)render) || infoChanged;
        }
        return this.sectionsWithGlobalEntities.add((Object)render) || infoChanged;
    }

    private static List<BuilderTaskOutput> filterChunkBuildResults(ArrayList<BuilderTaskOutput> outputs) {
        Reference2ReferenceLinkedOpenHashMap map = new Reference2ReferenceLinkedOpenHashMap();
        for (BuilderTaskOutput output : outputs) {
            RenderSection render;
            BuilderTaskOutput previous;
            if (output.render.isDisposed() || output.render.getLastUploadFrame() > output.submitTime || (previous = (BuilderTaskOutput)map.get((Object)(render = output.render))) != null && previous.submitTime >= output.submitTime) continue;
            map.put((Object)render, (Object)output);
        }
        return new ArrayList<BuilderTaskOutput>((Collection<BuilderTaskOutput>)map.values());
    }

    private ArrayList<BuilderTaskOutput> collectChunkBuildResults() {
        ChunkJobResult<? extends BuilderTaskOutput> result;
        ArrayList<BuilderTaskOutput> results = new ArrayList<BuilderTaskOutput>();
        while ((result = this.buildResults.poll()) != null) {
            results.add(result.unwrap());
            JobEffort jobEffort = result.getJobEffort();
            if (jobEffort == null) continue;
            this.jobDurationEstimator.addData(jobEffort);
        }
        this.jobDurationEstimator.updateModels();
        return results;
    }

    public void cleanupAndFlip() {
        this.sectionCache.cleanup();
        this.regions.update();
    }

    public void updateChunks(boolean updateImmediately) {
        this.thisFrameBlockingTasks = 0;
        this.nextFrameBlockingTasks = 0;
        this.deferredTasks = 0;
        ChunkJobCollector thisFrameBlockingCollector = this.lastBlockingCollector;
        this.lastBlockingCollector = null;
        if (thisFrameBlockingCollector == null) {
            thisFrameBlockingCollector = new ChunkJobCollector(this.buildResults::add);
        }
        if (updateImmediately) {
            this.submitSectionTasks(thisFrameBlockingCollector, thisFrameBlockingCollector, thisFrameBlockingCollector, UnlimitedResourceBudget.INSTANCE);
            this.thisFrameBlockingTasks = thisFrameBlockingCollector.getSubmittedTaskCount();
            thisFrameBlockingCollector.awaitCompletion(this.builder);
        } else {
            long remainingDuration = this.builder.getTotalRemainingDuration(this.averageFrameDuration);
            LimitedResourceBudget uploadBudget = new LimitedResourceBudget(Math.max((long)((float)this.averageFrameDuration * 0.1f), 2000000L), this.regions.getStagingBuffer().getUploadSizeLimit(this.averageFrameDuration));
            ChunkJobCollector nextFrameBlockingCollector = new ChunkJobCollector(this.buildResults::add);
            ChunkJobCollector deferredCollector = new ChunkJobCollector(remainingDuration, this.buildResults::add);
            if (this.sortBehavior.getDeferMode() == DeferMode.ZERO_FRAMES) {
                this.submitSectionTasks(thisFrameBlockingCollector, nextFrameBlockingCollector, deferredCollector, uploadBudget);
            } else {
                this.submitSectionTasks(nextFrameBlockingCollector, nextFrameBlockingCollector, deferredCollector, uploadBudget);
            }
            this.thisFrameBlockingTasks = thisFrameBlockingCollector.getSubmittedTaskCount();
            this.nextFrameBlockingTasks = nextFrameBlockingCollector.getSubmittedTaskCount();
            this.deferredTasks = deferredCollector.getSubmittedTaskCount();
            thisFrameBlockingCollector.awaitCompletion(this.builder);
            this.lastBlockingCollector = nextFrameBlockingCollector;
        }
    }

    private void submitSectionTasks(ChunkJobCollector importantCollector, ChunkJobCollector semiImportantCollector, ChunkJobCollector deferredCollector, UploadResourceBudget uploadBudget) {
        this.submitSectionTasks(importantCollector, uploadBudget, TaskQueueType.ZERO_FRAME_DEFER);
        this.submitSectionTasks(semiImportantCollector, uploadBudget, TaskQueueType.ONE_FRAME_DEFER);
        this.submitSectionTasks(deferredCollector, uploadBudget, TaskQueueType.ALWAYS_DEFER);
        this.submitSectionTasks(deferredCollector, uploadBudget, TaskQueueType.INITIAL_BUILD);
    }

    private void submitSectionTasks(ChunkJobCollector collector, UploadResourceBudget uploadBudget, TaskQueueType queueType) {
        RenderSection section;
        ArrayDeque<RenderSection> taskList = this.taskLists.get((Object)queueType);
        while (!taskList.isEmpty() && collector.hasBudgetRemaining() && (uploadBudget.isAvailable() || queueType.allowsUnlimitedUploadDuration()) && (section = taskList.poll()) != null) {
            int pendingUpdate = section.getPendingUpdate();
            if (pendingUpdate == 0) continue;
            this.submitSectionTask(collector, section, pendingUpdate, uploadBudget);
        }
    }

    private void submitSectionTask(ChunkJobCollector collector, @NotNull RenderSection section, int type, UploadResourceBudget uploadBudget) {
        ChunkBuilderTask task;
        if (section.isDisposed()) {
            return;
        }
        if (ChunkUpdateTypes.isInitialBuild(type) || ChunkUpdateTypes.isRebuild(type)) {
            task = this.createRebuildTask(section, this.frame);
            if (task == null) {
                NoData translucentData = null;
                if (this.sortBehavior != SortBehavior.OFF) {
                    translucentData = NoData.forEmptySection(section.getPosition());
                }
                ChunkJobResult<ChunkBuildOutput> result = ChunkJobResult.successfully(new ChunkBuildOutput(section, this.frame, translucentData, BuiltSectionInfo.EMPTY, Collections.emptyMap()));
                this.buildResults.add(result);
                section.setTaskCancellationToken(null);
            }
        } else {
            task = this.createSortTask(section, this.frame);
            if (task == null) {
                section.clearPendingUpdate();
                return;
            }
        }
        if (task != null) {
            ChunkJobTyped job = this.builder.scheduleTask(task, ChunkUpdateTypes.isImportant(type), collector::onJobFinished);
            collector.addSubmittedJob(job);
            uploadBudget.consume(job.getEstimatedUploadDuration(), job.getEstimatedSize());
            section.setTaskCancellationToken(job);
        }
        section.setLastSubmittedFrame(this.frame);
        section.clearPendingUpdate();
    }

    @Nullable
    public ChunkBuilderMeshingTask createRebuildTask(RenderSection render, int frame) {
        ChunkRenderContext context = LevelSlice.prepare((class_1937)this.level, render.getPosition(), this.sectionCache);
        if (context == null) {
            return null;
        }
        ChunkBuilderMeshingTask task = new ChunkBuilderMeshingTask(render, frame, this.cameraPosition, context, this.sortBehavior, ChunkUpdateTypes.isRebuildWithSort(render.getPendingUpdate()));
        task.calculateEstimations(this.jobDurationEstimator, this.meshTaskSizeEstimator, this.jobUploadDurationEstimator);
        return task;
    }

    public ChunkBuilderSortingTask createSortTask(RenderSection render, int frame) {
        ChunkBuilderSortingTask task = ChunkBuilderSortingTask.createTask(render, frame, this.cameraPosition);
        if (task != null) {
            task.calculateEstimations(this.jobDurationEstimator, this.meshTaskSizeEstimator, this.jobUploadDurationEstimator);
        }
        return task;
    }

    public void processGFNIMovement(CameraMovement movement) {
        if (this.sortTriggering != null) {
            this.sortTriggering.triggerSections(this::scheduleSort, movement);
        }
    }

    public void markGraphDirty() {
        this.needsGraphUpdate = true;
    }

    public boolean needsUpdate() {
        return this.needsGraphUpdate;
    }

    public ChunkBuilder getBuilder() {
        return this.builder;
    }

    public void destroy() {
        this.builder.shutdown();
        for (BuilderTaskOutput result : this.collectChunkBuildResults()) {
            result.destroy();
        }
        for (RenderSection section : this.sectionByPosition.values()) {
            section.delete();
        }
        this.sectionsWithGlobalEntities.clear();
        this.resetRenderLists();
        try (CommandList commandList = RenderDevice.INSTANCE.createCommandList();){
            this.regions.delete(commandList);
            this.chunkRenderer.delete(commandList);
        }
    }

    public int getTotalSections() {
        return this.sectionByPosition.size();
    }

    public int getVisibleChunkCount() {
        int sections = 0;
        Iterator<ChunkRenderList> iterator = this.renderLists.iterator();
        while (iterator.hasNext()) {
            ChunkRenderList renderList = iterator.next();
            sections += renderList.getSectionsWithGeometryCount();
        }
        return sections;
    }

    private boolean upgradePendingUpdate(RenderSection section, int updateType) {
        if (updateType == 0) {
            return false;
        }
        int current = section.getPendingUpdate();
        int joined = ChunkUpdateTypes.join(current, updateType);
        if (joined == current) {
            return false;
        }
        section.setPendingUpdate(joined, this.lastFrameAtTime);
        this.markGraphDirty();
        return true;
    }

    public void scheduleSort(long sectionPos, boolean isDirectTrigger) {
        RenderSection section = (RenderSection)this.sectionByPosition.get(sectionPos);
        if (section != null) {
            int pendingUpdate = 1;
            SortBehavior.PriorityMode priorityMode = this.sortBehavior.getPriorityMode();
            if (priorityMode == SortBehavior.PriorityMode.NEARBY && this.shouldPrioritizeTask(section, NEARBY_SORT_DISTANCE) || priorityMode == SortBehavior.PriorityMode.ALL) {
                pendingUpdate = ChunkUpdateTypes.join(pendingUpdate, 4);
            }
            if (this.upgradePendingUpdate(section, pendingUpdate)) {
                section.prepareTrigger(isDirectTrigger);
            }
        }
    }

    public void scheduleRebuild(int x, int y, int z, boolean playerChanged) {
        RenderAsserts.validateCurrentThread();
        this.sectionCache.invalidate(x, y, z);
        RenderSection section = (RenderSection)this.sectionByPosition.get(class_4076.method_18685((int)x, (int)y, (int)z));
        if (section != null && section.isBuilt()) {
            int pendingUpdate = playerChanged && this.shouldPrioritizeTask(section, NEARBY_REBUILD_DISTANCE) ? ChunkUpdateTypes.join(2, 4) : 2;
            this.upgradePendingUpdate(section, pendingUpdate);
        }
    }

    private boolean shouldPrioritizeTask(RenderSection section, float distance) {
        return this.cameraPosition != null && section.getSquaredDistance((float)this.cameraPosition.x(), (float)this.cameraPosition.y(), (float)this.cameraPosition.z()) < distance;
    }

    private float getEffectiveRenderDistance(FogParameters fogParameters) {
        float alpha = fogParameters.alpha();
        float distance = fogParameters.renderEnd();
        float renderDistance = this.getRenderDistance();
        if (!class_3532.method_15347((float)alpha, (float)1.0f)) {
            return renderDistance;
        }
        return Math.min(renderDistance, distance + 0.5f);
    }

    private float getRenderDistance() {
        return (float)this.renderDistance * 16.0f;
    }

    private void connectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = this.getRenderSection(render.getChunkX() + GraphDirection.x(direction), render.getChunkY() + GraphDirection.y(direction), render.getChunkZ() + GraphDirection.z(direction));
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), render);
            render.setAdjacentNode(direction, adj);
        }
    }

    private void disconnectNeighborNodes(RenderSection render) {
        for (int direction = 0; direction < 6; ++direction) {
            RenderSection adj = render.getAdjacent(direction);
            if (adj == null) continue;
            adj.setAdjacentNode(GraphDirection.opposite(direction), null);
            render.setAdjacentNode(direction, null);
        }
    }

    private RenderSection getRenderSection(int x, int y, int z) {
        return (RenderSection)this.sectionByPosition.get(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    public Collection<String> getDebugStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        long geometryDeviceUsed = 0L;
        long geometryDeviceAllocated = 0L;
        long indexDeviceUsed = 0L;
        long indexDeviceAllocated = 0L;
        for (RenderRegion region : this.regions.getLoadedRegions()) {
            RenderRegion.DeviceResources resources = region.getResources();
            if (resources == null) continue;
            GlBufferArena geometryArena = resources.getGeometryArena();
            geometryDeviceUsed += geometryArena.getDeviceUsedMemory();
            geometryDeviceAllocated += geometryArena.getDeviceAllocatedMemory();
            GlBufferArena indexArena = resources.getIndexArena();
            indexDeviceUsed += indexArena.getDeviceUsedMemory();
            indexDeviceAllocated += indexArena.getDeviceAllocatedMemory();
            ++count;
        }
        list.add(String.format("Pools: Geometry %d/%d MiB, Index %d/%d MiB (%d buffers)", MathUtil.toMib(geometryDeviceUsed), MathUtil.toMib(geometryDeviceAllocated), MathUtil.toMib(indexDeviceUsed), MathUtil.toMib(indexDeviceAllocated), count));
        list.add(String.format("Transfer Queue: %s", this.regions.getStagingBuffer().toString()));
        list.add(String.format("Chunk Builder: Schd=%02d | Busy=%02d (%04d%%) | Total=%02d", this.builder.getScheduledJobCount(), this.builder.getBusyThreadCount(), (int)(this.builder.getBusyFraction(this.lastFrameDuration) * 100.0f), this.builder.getTotalThreadCount()));
        list.add(String.format("Tasks: N0=%03d | N1=%03d | Def=%03d, Recv=%03d", this.thisFrameBlockingTasks, this.nextFrameBlockingTasks, this.deferredTasks, this.buildResults.size()));
        if (PlatformRuntimeInformation.getInstance().isDevelopmentEnvironment()) {
            String meshTaskParameters = this.jobDurationEstimator.toString(ChunkBuilderMeshingTask.class);
            String sortTaskParameters = this.jobDurationEstimator.toString(ChunkBuilderSortingTask.class);
            String uploadDurationParameters = this.jobUploadDurationEstimator.toString(null);
            list.add(String.format("Duration: Mesh %s, Sort %s, Upload %s", meshTaskParameters, sortTaskParameters, uploadDurationParameters));
            ReferenceArrayList sizeEstimates = new ReferenceArrayList();
            for (MeshResultSize.SectionCategory type : MeshResultSize.SectionCategory.values()) {
                sizeEstimates.add((Object)String.format("%s=%s", new Object[]{type, this.meshTaskSizeEstimator.toString(type)}));
            }
            list.add(String.format("Size: %s", String.join((CharSequence)", ", (Iterable<? extends CharSequence>)sizeEstimates)));
        }
        if (this.sortBehavior != SortBehavior.OFF) {
            this.sortTriggering.addDebugStrings(list, this.sortBehavior);
        } else {
            list.add("TS OFF");
        }
        return list;
    }

    @NotNull
    public SortedRenderLists getRenderLists() {
        return this.renderLists;
    }

    public boolean isSectionBuilt(int x, int y, int z) {
        RenderSection section = this.getRenderSection(x, y, z);
        return section != null && section.isBuilt();
    }

    public void onChunkAdded(int x, int z) {
        for (int y = this.level.method_32891(); y <= this.level.method_31597(); ++y) {
            this.onSectionAdded(x, y, z);
        }
    }

    public void onChunkRemoved(int x, int z) {
        for (int y = this.level.method_32891(); y <= this.level.method_31597(); ++y) {
            this.onSectionRemoved(x, y, z);
        }
    }

    public Collection<RenderSection> getSectionsWithGlobalEntities() {
        return ReferenceSets.unmodifiable(this.sectionsWithGlobalEntities);
    }
}

