/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.util;

import org.joml.Math;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class MathUtil {
    public static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    public static long toMib(long bytes) {
        return bytes / 0x100000L;
    }

    public static int align(int num, int alignment) {
        int additive = alignment - 1;
        int mask = ~additive;
        return num + additive & mask;
    }

    public static int floatToComparableInt(float f) {
        int bits = Float.floatToRawIntBits(f);
        return bits ^ bits >> 31 & Integer.MAX_VALUE;
    }

    public static float comparableIntToFloat(int i) {
        return Float.intBitsToFloat(i ^ i >> 31 & Integer.MAX_VALUE);
    }

    public static float exponentialMovingAverage(float oldValue, float newValue, float newValueContribution) {
        return newValueContribution * newValue + (1.0f - newValueContribution) * oldValue;
    }

    public static long exponentialMovingAverage(long oldValue, long newValue, float newValueContribution) {
        return (long)(newValueContribution * (float)newValue) + (long)((1.0f - newValueContribution) * (float)oldValue);
    }

    public static double floatDoubleDot(Vector3fc a, Vector3dc b) {
        return Math.fma((double)a.x(), (double)b.x(), (double)Math.fma((double)a.y(), (double)b.y(), (double)((double)a.z() * b.z())));
    }

    public static double floatDoubleDot(Vector3fc a, double bx, double by, double bz) {
        return Math.fma((double)a.x(), (double)bx, (double)Math.fma((double)a.y(), (double)by, (double)((double)a.z() * bz)));
    }
}

