/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.AccessorImpl;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.ServerPayloadContext;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorImpl
extends AccessorImpl<class_3965>
implements BlockAccessor {
    private final class_2680 blockState;
    @Nullable
    private final java.util.function.Supplier<class_2586> blockEntity;
    private class_1799 serversideRep;

    private BlockAccessorImpl(Builder builder) {
        super(builder.level, builder.player, builder.serverData, Suppliers.ofInstance((Object)builder.hit), builder.connected, builder.showDetails);
        this.blockState = builder.blockState;
        this.blockEntity = builder.blockEntity;
        this.serversideRep = builder.serversideRep;
    }

    public static void handleRequest(RequestBlockPacket message, ServerPayloadContext context, Consumer<class_2487> responseSender) {
        class_3222 player = context.player();
        context.execute(() -> {
            BlockAccessor accessor = message.data().unpack(player);
            if (accessor == null) {
                return;
            }
            class_2338 pos = accessor.getPosition();
            class_3218 world = player.method_51469();
            double maxDistance = class_3532.method_33723((double)(player.method_55754() + 21.0));
            if (pos.method_10262((class_2382)player.method_24515()) > maxDistance || !world.method_8477(pos)) {
                return;
            }
            List<IServerDataProvider<BlockAccessor>> providers = WailaCommonRegistration.instance().blockDataProvidersOf(accessor.getBlockState(), accessor.getBlockEntity(), true);
            class_2487 tag = accessor.getServerData();
            for (IServerDataProvider<BlockAccessor> provider : providers) {
                if (!message.dataProviders().contains(provider)) continue;
                try {
                    provider.appendServerData(tag, accessor);
                }
                catch (Exception e) {
                    WailaExceptionHandler.handleErr(e, provider, null);
                }
            }
            tag.method_10569("x", pos.method_10263());
            tag.method_10569("y", pos.method_10264());
            tag.method_10569("z", pos.method_10260());
            tag.method_10582("BlockId", CommonProxy.getId(accessor.getBlock()).toString());
            responseSender.accept(tag);
        });
    }

    @Override
    public class_2248 getBlock() {
        return this.getBlockState().method_26204();
    }

    @Override
    public class_2680 getBlockState() {
        return this.blockState;
    }

    @Override
    public class_2586 getBlockEntity() {
        return this.blockEntity == null ? null : this.blockEntity.get();
    }

    @Override
    public class_2338 getPosition() {
        return ((class_3965)this.getHitResult()).method_17777();
    }

    @Override
    public class_2350 getSide() {
        return ((class_3965)this.getHitResult()).method_17780();
    }

    @Override
    public class_1799 getPickedResult() {
        if (this.isServersideContent()) {
            return this.getServersideRep();
        }
        return CommonProxy.getBlockPickedResult(this.blockState, this.getPlayer(), (class_3965)this.getHitResult());
    }

    @Override
    @Nullable
    public Object getTarget() {
        return this.getBlockEntity();
    }

    @Override
    public class_1799 getServersideRep() {
        return this.serversideRep;
    }

    public void setServersideRep(class_1799 serversideRep) {
        this.serversideRep = serversideRep;
    }

    @Override
    public boolean verifyData(class_2487 data) {
        if (!this.verify) {
            return true;
        }
        int x = data.method_68083("x", 0);
        int y = data.method_68083("y", 0);
        int z = data.method_68083("z", 0);
        class_2338 hitPos = this.getPosition();
        return x == hitPos.method_10263() && y == hitPos.method_10264() && z == hitPos.method_10260();
    }

    public static class Builder
    implements BlockAccessor.Builder {
        private class_1937 level;
        private class_1657 player;
        private class_2487 serverData;
        private boolean connected;
        private boolean showDetails;
        private class_3965 hit;
        private class_2680 blockState = class_2246.field_10124.method_9564();
        private java.util.function.Supplier<class_2586> blockEntity;
        private class_1799 serversideRep = class_1799.field_8037;
        private boolean verify;

        @Override
        public Builder level(class_1937 level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder player(class_1657 player) {
            this.player = player;
            return this;
        }

        @Override
        public Builder serverData(class_2487 serverData) {
            this.serverData = serverData;
            return this;
        }

        @Override
        public Builder serverConnected(boolean connected) {
            this.connected = connected;
            return this;
        }

        @Override
        public Builder showDetails(boolean showDetails) {
            this.showDetails = showDetails;
            return this;
        }

        @Override
        public Builder hit(class_3965 hit) {
            this.hit = hit;
            return this;
        }

        @Override
        public Builder blockState(class_2680 blockState) {
            this.blockState = blockState;
            return this;
        }

        @Override
        public Builder blockEntity(java.util.function.Supplier<class_2586> blockEntity) {
            this.blockEntity = blockEntity;
            return this;
        }

        @Override
        public Builder serversideRep(class_1799 stack) {
            this.serversideRep = stack;
            return this;
        }

        @Override
        public Builder from(BlockAccessor accessor) {
            this.level = accessor.getLevel();
            this.player = accessor.getPlayer();
            this.serverData = accessor.getServerData().method_10553();
            this.connected = accessor.isServerConnected();
            this.showDetails = accessor.showDetails();
            this.hit = (class_3965)accessor.getHitResult();
            this.blockEntity = accessor::getBlockEntity;
            this.blockState = accessor.getBlockState();
            this.serversideRep = accessor.getServersideRep();
            return this;
        }

        @Override
        public BlockAccessor.Builder requireVerification() {
            this.verify = true;
            return this;
        }

        @Override
        public BlockAccessor build() {
            BlockAccessorImpl accessor = new BlockAccessorImpl(this);
            if (this.verify) {
                accessor.requireVerification();
            }
            return accessor;
        }
    }

    public record SyncData(boolean showDetails, class_3965 hit, class_1799 serversideRep, class_2487 data) {
        public static final class_9139<class_9129, SyncData> STREAM_CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, SyncData::showDetails, (class_9139)class_9139.method_56437(class_2540::method_17813, class_2540::method_17814), SyncData::hit, (class_9139)class_1799.field_49268, SyncData::serversideRep, (class_9139)class_9135.field_48556, SyncData::data, SyncData::new);

        public SyncData(BlockAccessor accessor) {
            this(accessor.showDetails(), (class_3965)accessor.getHitResult(), accessor.getServersideRep(), accessor.getServerData());
        }

        public BlockAccessor unpack(class_3222 player) {
            Supplier blockEntity = null;
            class_2680 blockState = player.method_51469().method_8320(this.hit.method_17777());
            if (blockState.method_31709()) {
                blockEntity = Suppliers.memoize(() -> player.method_51469().method_8321(this.hit.method_17777()));
            }
            return ((Builder)new Builder().level((class_1937)player.method_51469()).player((class_1657)player).showDetails(this.showDetails).hit(this.hit).blockState(blockState).blockEntity((java.util.function.Supplier)blockEntity)).serversideRep(this.serversideRep).serverData(this.data).build();
        }
    }
}

