/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.TargetOperationRepository;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.config.TargetOperationRepositoryImpl;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.impl.lookup.PairHierarchyLookup;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;
import snownee.jade.util.CommonProxy;

public class WailaCommonRegistration
implements IWailaCommonRegistration {
    private static volatile WailaCommonRegistration INSTANCE = new WailaCommonRegistration();
    public final PairHierarchyLookup<IServerDataProvider<BlockAccessor>> blockDataProviders = new PairHierarchyLookup(new HierarchyLookup(class_2248.class), new HierarchyLookup(class_2586.class));
    public final HierarchyLookup<IServerDataProvider<EntityAccessor>> entityDataProviders;
    public final PriorityStore<class_2960, IJadeProvider> priorities;
    public final WrappedHierarchyLookup<IServerExtensionProvider<class_1799>> itemStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<FluidView.Data>> fluidStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<EnergyView.Data>> energyStorageProviders;
    public final WrappedHierarchyLookup<IServerExtensionProvider<ProgressView.Data>> progressProviders;
    private final TargetOperationRepositoryImpl<class_2248, class_2680> blockOperations;
    private final TargetOperationRepositoryImpl<class_1299<?>, class_1297> entityTypeOperations;
    private final TargetOperationRepositoryImpl<class_1291, class_1293> mobEffectOperations;

    WailaCommonRegistration() {
        this.blockDataProviders.idMapped();
        this.entityDataProviders = new HierarchyLookup(class_1297.class);
        this.entityDataProviders.idMapped();
        this.priorities = new PriorityStore<class_2960, IJadeProvider>(IJadeProvider::getDefaultPriority, IJadeProvider::getUid);
        this.priorities.setSortingFunction((store, allKeys) -> {
            List keys = allKeys.stream().filter(IPluginConfig::isPrimaryKey).sorted(Comparator.comparingInt(store::byKey)).collect(Collectors.toCollection(ArrayList::new));
            allKeys.stream().filter(Predicate.not(IPluginConfig::isPrimaryKey)).forEach($ -> {
                int index = keys.indexOf(IPluginConfig.getPrimaryKey($));
                keys.add(index + 1, $);
            });
            return keys;
        });
        this.priorities.configurable("jade/sort-order", (Codec<class_2960>)class_2960.field_25139);
        this.itemStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.fluidStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.energyStorageProviders = WrappedHierarchyLookup.forAccessor();
        this.progressProviders = WrappedHierarchyLookup.forAccessor();
        this.blockOperations = new TargetOperationRepositoryImpl(class_7924.field_41254, $ -> (class_5321)$.method_41520().method_40230().orElseThrow(), "hide-blocks", () -> CommonProxy.isPhysicallyClient() ? List.of("barrier") : List.of());
        this.entityTypeOperations = new TargetOperationRepositoryImpl(class_7924.field_41266, $ -> $.method_5864().method_40124().method_40237(), "hide-entities", () -> CommonProxy.isPhysicallyClient() ? List.of("area_effect_cloud", "firework_rocket", "interaction", "text_display", "lightning_bolt") : List.of());
        this.mobEffectOperations = new TargetOperationRepositoryImpl(class_7924.field_41208, $ -> (class_5321)$.method_5579().method_40230().orElseThrow(), "hide-mob-effects", List::of);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WailaCommonRegistration instance() {
        if (INSTANCE != null) return INSTANCE;
        Jade.LOGGER.error("WailaCommonRegistration is not initialized yet.");
        Class<WailaCommonRegistration> clazz = WailaCommonRegistration.class;
        synchronized (WailaCommonRegistration.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WailaCommonRegistration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Class<WailaCommonRegistration> clazz = WailaCommonRegistration.class;
        synchronized (WailaCommonRegistration.class) {
            INSTANCE = new WailaCommonRegistration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void registerBlockDataProvider(IServerDataProvider<BlockAccessor> dataProvider, Class<?> blockOrBlobkEntityClass) {
        WailaCommonRegistration.checkDataProvider(dataProvider);
        this.blockDataProviders.register(blockOrBlobkEntityClass, dataProvider);
    }

    @Override
    public void registerEntityDataProvider(IServerDataProvider<EntityAccessor> dataProvider, Class<? extends class_1297> entityClass) {
        WailaCommonRegistration.checkDataProvider(dataProvider);
        this.entityDataProviders.register(entityClass, dataProvider);
    }

    private static void checkDataProvider(IServerDataProvider<?> dataProvider) {
        if (CommonProxy.isPhysicallyClient() && dataProvider instanceof IComponentProvider) {
            throw new IllegalArgumentException("Data providers cannot implement IComponentProvider since Minecraft 1.21.6. Use a separate client provider instead.");
        }
    }

    public List<IServerDataProvider<BlockAccessor>> blockDataProvidersOf(class_2680 blockState, @Nullable class_2586 blockEntity, boolean checkIsHidden) {
        if (checkIsHidden && this.blockOperations().shouldHide(blockState)) {
            return List.of();
        }
        if (blockEntity == null) {
            return this.blockDataProviders.first.get(blockState.method_26204());
        }
        return this.blockDataProviders.getMerged(blockState.method_26204(), blockEntity);
    }

    public List<IServerDataProvider<EntityAccessor>> entityDataProvidersOf(class_1297 entity) {
        if (this.entityTypeOperations().shouldHide(entity)) {
            return List.of();
        }
        return this.entityDataProviders.get(entity);
    }

    public void loadComplete() {
        this.blockDataProviders.loadComplete(this.priorities);
        this.entityDataProviders.loadComplete(this.priorities);
        this.itemStorageProviders.loadComplete(this.priorities);
        this.fluidStorageProviders.loadComplete(this.priorities);
        this.energyStorageProviders.loadComplete(this.priorities);
        this.progressProviders.loadComplete(this.priorities);
    }

    public void reloadOperations(class_7225.class_7874 provider) {
        this.blockOperations.reload(provider);
        this.entityTypeOperations.reload(provider);
        this.mobEffectOperations.reload(provider);
    }

    @Override
    public TargetOperationRepository<class_2248, class_2680> blockOperations() {
        return this.blockOperations;
    }

    @Override
    public TargetOperationRepository<class_1299<?>, class_1297> entityTypeOperations() {
        return this.entityTypeOperations;
    }

    @Override
    public TargetOperationRepository<class_1291, class_1293> mobEffectOperations() {
        return this.mobEffectOperations;
    }

    @Override
    public <T> void registerItemStorage(IServerExtensionProvider<class_1799> provider, Class<? extends T> clazz) {
        this.itemStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerFluidStorage(IServerExtensionProvider<FluidView.Data> provider, Class<? extends T> clazz) {
        this.fluidStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerEnergyStorage(IServerExtensionProvider<EnergyView.Data> provider, Class<? extends T> clazz) {
        this.energyStorageProviders.register(clazz, provider);
    }

    @Override
    public <T> void registerProgress(IServerExtensionProvider<ProgressView.Data> provider, Class<? extends T> clazz) {
        this.progressProviders.register(clazz, provider);
    }
}

