/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.track.HealthTrackInfo;

public class HealthElement
extends Element {
    public static final class_2960 HEART = class_2960.method_60656((String)"hud/heart/full");
    public static final class_2960 HEART_BLINKING = class_2960.method_60656((String)"hud/heart/full_blinking");
    public static final class_2960 HALF_HEART = class_2960.method_60656((String)"hud/heart/half");
    public static final class_2960 HALF_HEART_BLINKING = class_2960.method_60656((String)"hud/heart/half_blinking");
    public static final class_2960 EMPTY_HEART = class_2960.method_60656((String)"hud/heart/container");
    public static final class_2960 EMPTY_HEART_BLINKING = class_2960.method_60656((String)"hud/heart/container_blinking");
    private final float health;
    private String text;
    private int iconsPerLine = 1;
    private int lineCount = 1;
    private int iconCount = 1;
    private HealthTrackInfo track;

    public HealthElement(float maxHealth, float health) {
        this.health = health;
        IPluginConfig config = IWailaConfig.get().plugin();
        if (maxHealth > (float)config.getInt(JadeIds.MC_ENTITY_HEALTH_MAX_FOR_RENDER)) {
            if (!config.get(JadeIds.MC_ENTITY_HEALTH_SHOW_FRACTIONS)) {
                maxHealth = class_3532.method_15386((float)maxHealth);
                health = class_3532.method_15386((float)health);
            }
            this.text = String.format("%s/%s", DisplayHelper.dfCommas.format(health), DisplayHelper.dfCommas.format(maxHealth));
        } else {
            int maxHeartsPerLine = config.getInt(JadeIds.MC_ENTITY_HEALTH_ICONS_PER_LINE);
            this.iconCount = class_3532.method_15386((float)(maxHealth *= 0.5f));
            this.iconsPerLine = Math.min(maxHeartsPerLine, this.iconCount);
            this.lineCount = class_3532.method_15386((float)(maxHealth / (float)maxHeartsPerLine));
        }
        if (this.showText()) {
            this.width = DisplayHelper.font().method_1727(this.text) + 10;
            this.height = 9;
        } else {
            this.width = 8 * this.iconsPerLine + 1;
            this.height = 5 + 4 * this.lineCount;
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        float health;
        float lastHealth = health = this.health * 0.5f;
        boolean blink = false;
        if (this.track == null && this.getTag() != null) {
            this.track = JadeClient.tickHandler().progressTracker.getOrCreate(this.getTag(), HealthTrackInfo.class, () -> new HealthTrackInfo(this.health));
        }
        if (this.track != null) {
            this.track.setHealth(this.health);
            this.track.update(class_310.method_1551().method_61966().method_60638());
            lastHealth = this.track.getLastHealth() * 0.5f;
            blink = this.track.isBlinking();
        }
        IDisplayHelper helper = IDisplayHelper.get();
        int xOffset = (this.iconCount - 1) % this.iconsPerLine * 8;
        int yOffset = this.lineCount * 4 - 4;
        for (int i = this.iconCount; i > 0; --i) {
            int xPos = this.method_46426() + xOffset;
            int yPos = this.method_46427() + yOffset;
            helper.blitSprite(graphics, class_10799.field_56883, blink ? EMPTY_HEART_BLINKING : EMPTY_HEART, xPos, yPos, 9, 9);
            if (i <= class_3532.method_15375((float)health)) {
                helper.blitSprite(graphics, class_10799.field_56883, HEART, xPos, yPos, 9, 9);
            }
            if ((float)i > health) {
                if (i <= class_3532.method_15375((float)lastHealth)) {
                    helper.blitSprite(graphics, class_10799.field_56883, HEART_BLINKING, xPos, yPos, 9, 9);
                } else if ((float)i > lastHealth && (float)i < lastHealth + 1.0f) {
                    helper.blitSprite(graphics, class_10799.field_56883, HALF_HEART_BLINKING, xPos, yPos, 9, 9);
                }
                if ((float)i < health + 1.0f) {
                    helper.blitSprite(graphics, class_10799.field_56883, HALF_HEART, xPos, yPos, 9, 9);
                }
            }
            if ((xOffset -= 8) >= 0) continue;
            xOffset = this.iconsPerLine * 8 - 8;
            yOffset -= 4;
        }
        if (this.showText()) {
            helper.drawText(graphics, this.text, (float)(this.method_46426() + 10), (float)(this.method_46427() + 1), IThemeHelper.get().getNormalColor());
        }
    }

    @Override
    public class_2561 getNarration() {
        return class_2561.method_43469((String)"narration.jade.health", (Object[])new Object[]{class_3532.method_15386((float)this.health)});
    }

    public boolean showText() {
        return this.text != null;
    }
}

