/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class NativeUtils {
    @Nullable
    public static <T> T createSafe(SafeSupplier<T> supplier, @Nullable Consumer<Throwable> onError, long waitTime) {
        AtomicReference exception = new AtomicReference();
        AtomicReference obj = new AtomicReference();
        Thread t = new Thread(() -> {
            if (onError != null) {
                Thread.setDefaultUncaughtExceptionHandler((t1, e) -> exception.set(e));
            }
            try {
                obj.set(supplier.get());
            }
            catch (Throwable e2) {
                exception.set(e2);
            }
        }, "NativeInitializationThread");
        t.start();
        try {
            t.join(waitTime);
        }
        catch (InterruptedException e) {
            return null;
        }
        Throwable ex = (Throwable)exception.get();
        if (onError != null && ex != null) {
            onError.accept(ex);
        }
        return (T)obj.get();
    }

    @Nullable
    public static <T> T createSafe(SafeSupplier<T> supplier, @Nullable Consumer<Throwable> onError) {
        return NativeUtils.createSafe(supplier, onError, 5000L);
    }

    @Nullable
    public static <T> T createSafe(SafeSupplier<T> supplier) {
        return NativeUtils.createSafe(supplier, null);
    }

    @FunctionalInterface
    public static interface SafeSupplier<T> {
        public T get() throws Throwable;
    }
}

