/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.onboarding.OnboardingManager;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.plugins.ClientPluginManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.UUID;
import net.minecraft.class_10055;
import net.minecraft.class_10799;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import org.joml.Quaternionfc;

public class RenderEvents {
    private static final class_2960 MICROPHONE_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone.png");
    private static final class_2960 WHISPER_MICROPHONE_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone_whisper.png");
    private static final class_2960 MICROPHONE_OFF_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/microphone_off.png");
    private static final class_2960 SPEAKER_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker.png");
    private static final class_2960 WHISPER_SPEAKER_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_whisper.png");
    private static final class_2960 SPEAKER_OFF_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/speaker_off.png");
    private static final class_2960 DISCONNECT_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/disconnected.png");
    private static final class_2960 GROUP_ICON = class_2960.method_60655((String)"voicechat", (String)"textures/icons/group.png");
    private final class_310 minecraft = class_310.method_1551();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(class_332 guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showHudIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && VoicechatClient.CLIENT_CONFIG.showGroupHud.get().booleanValue()) {
            GroupChatManager.renderIcons(guiGraphics);
        }
    }

    private boolean isStartup() {
        ClientVoicechat client = ClientManager.getClient();
        return client != null && System.currentTimeMillis() - client.getStartTime() < 5000L;
    }

    private void renderIcon(class_332 guiGraphics, class_2960 texture) {
        guiGraphics.method_51448().pushMatrix();
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            guiGraphics.method_51448().translate((float)this.minecraft.method_22683().method_4486(), 0.0f);
        }
        if (posY < 0) {
            guiGraphics.method_51448().translate(0.0f, (float)this.minecraft.method_22683().method_4502());
        }
        guiGraphics.method_51448().translate((float)posX, (float)posY);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        guiGraphics.method_51448().scale(scale, scale);
        guiGraphics.method_25290(class_10799.field_56883, texture, posX < 0 ? -16 : 0, posY < 0 ? -16 : 0, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.method_51448().popMatrix();
    }

    private void onRenderName(class_10055 state, class_12075 cameraRenderState, class_4587 stack, class_11659 collector) {
        class_2561 nameTag = state.field_53337;
        if (nameTag == null) {
            return;
        }
        if (state.field_53338 == null) {
            return;
        }
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!VoicechatClient.CLIENT_CONFIG.showNametagIcons.get().booleanValue()) {
            return;
        }
        if (this.minecraft.field_1724 == null || this.minecraft.field_1687 == null) {
            return;
        }
        class_1297 entity = this.minecraft.field_1687.method_8469(state.field_53528);
        if (entity == null || entity.equals((Object)this.minecraft.field_1724)) {
            return;
        }
        if (this.minecraft.field_1690.field_1842) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        UUID entityId = entity.method_5667();
        UUID groupId = manager.getGroup(entityId);
        stack.method_22903();
        stack.method_61958(state.field_53338);
        stack.method_22904(0.0, 0.5, 0.0);
        stack.method_22907((Quaternionfc)cameraRenderState.field_63081);
        stack.method_22905(0.025f, -0.025f, 0.025f);
        if (client != null && client.getTalkCache().isWhispering(entityId)) {
            this.renderPlayerIcon(entityId, state.field_53334, nameTag, WHISPER_SPEAKER_ICON, stack, collector, state.field_61820);
        } else if (client != null && client.getTalkCache().isTalking(entityId)) {
            this.renderPlayerIcon(entityId, state.field_53334, nameTag, SPEAKER_ICON, stack, collector, state.field_61820);
        } else if (manager.isPlayerDisconnected(entityId)) {
            this.renderPlayerIcon(entityId, state.field_53334, nameTag, DISCONNECT_ICON, stack, collector, state.field_61820);
        } else if (groupId != null && !groupId.equals(manager.getGroupID())) {
            this.renderPlayerIcon(entityId, state.field_53334, nameTag, GROUP_ICON, stack, collector, state.field_61820);
        } else if (manager.isPlayerDisabled(entityId)) {
            this.renderPlayerIcon(entityId, state.field_53334, nameTag, SPEAKER_OFF_ICON, stack, collector, state.field_61820);
        }
        stack.method_22909();
    }

    private void renderPlayerIcon(UUID entityId, boolean discrete, class_2561 component, class_2960 texture, class_4587 stack, class_11659 collector, int light) {
        if (!ClientPluginManager.instance().shouldRenderPlayerIcons(entityId)) {
            return;
        }
        float offsetX = this.minecraft.field_1772.method_27525((class_5348)component) / 2 + 2;
        int alpha = 32;
        float offsetY = -1.0f;
        collector.method_73483(stack, class_1921.method_23028((class_2960)texture), (pose, c) -> {
            if (discrete) {
                RenderEvents.vertex(c, pose, offsetX, 10.0f + offsetY, 0.0f, 0.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, 10.0f + offsetY, 0.0f, 1.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, offsetY, 0.0f, 1.0f, 0.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX, offsetY, 0.0f, 0.0f, 0.0f, alpha, light);
            } else {
                RenderEvents.vertex(c, pose, offsetX, 10.0f + offsetY, 0.0f, 0.0f, 1.0f, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, 10.0f + offsetY, 0.0f, 1.0f, 1.0f, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, offsetY, 0.0f, 1.0f, 0.0f, light);
                RenderEvents.vertex(c, pose, offsetX, offsetY, 0.0f, 0.0f, 0.0f, light);
            }
        });
        if (!discrete) {
            collector.method_73483(stack, class_1921.method_23030((class_2960)texture), (pose, c) -> {
                RenderEvents.vertex(c, pose, offsetX, 10.0f + offsetY, 0.0f, 0.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, 10.0f + offsetY, 0.0f, 1.0f, 1.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX + 10.0f, offsetY, 0.0f, 1.0f, 0.0f, alpha, light);
                RenderEvents.vertex(c, pose, offsetX, offsetY, 0.0f, 0.0f, 0.0f, alpha, light);
            });
        }
    }

    private boolean shouldShowIcons() {
        if (OnboardingManager.isOnboarding()) {
            return false;
        }
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isInitialized()) {
            return true;
        }
        return this.minecraft.method_1576() == null || this.minecraft.method_1576().method_3860();
    }

    private static void vertex(class_4588 builder, class_4587.class_4665 pose, float x, float y, float z, float u, float v, int light) {
        RenderEvents.vertex(builder, pose, x, y, z, u, v, 255, light);
    }

    private static void vertex(class_4588 builder, class_4587.class_4665 pose, float x, float y, float z, float u, float v, int alpha, int light) {
        builder.method_22918(pose.method_23761(), x, y, z).method_1336(255, 255, 255, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 0.0f, -1.0f);
    }
}

